<?php
namespace Widget\PaymentBundle\Event;

use Symfony\Component\EventDispatcher\Event;

class UpdatePaymentTypeEvent extends Event
{
    const EVENT_NAME = 'event.widget.payment.update.payment.type';

    protected $ordernumber;
    protected $paymentType;

    public function __construct($ordernumber, $paymentType)
    {
        $this->ordernumber = $ordernumber;
        $this->paymentType = $paymentType;
    }

    /**
     * @return string
     */
    public function getOrdernumber()
    {
        return $this->ordernumber;
    }

    /**
     * @return string
     */
    public function getPaymentType()
    {
        return $this->paymentType;
    }
}