<?php
namespace Widget\PaymentBundle\Event;

use Symfony\Component\EventDispatcher\Event;

class ReceivePaymentnumberEvent extends Event
{
    const EVENT_NAME = 'event.widget.payment.receive.paymentnumber';

    protected $ordernumber;
    protected $paymentnumber;
    protected $originInfo;
    protected $expiredAt;

    public function __construct($ordernumber, $paymentnumber, \DateTime $expiredAt, $originInfo)
    {
        $this->ordernumber = $ordernumber;
        $this->paymentnumber = $paymentnumber;
        $this->originInfo = $originInfo;
        $this->expiredAt = $expiredAt;
    }

    /**
     *訂單編號
     */
    public function getOrdernumber()
    {
        return $this->ordernumber;
    }

    /**
     * 繳款代碼
     */
    public function getPaymentnumber()
    {
        return $this->paymentnumber;
    }

    /**
     * 原始繳款資訊
     */
    public function getOriginInfo()
    {
        return $this->originInfo;
    }

    /**
     * 繳款有效期限
     * @return \DateTime
     */
    public function getExpiredAt()
    {
        return $this->expiredAt;
    }

}