<?php
namespace Widget\PaymentBundle\Event;

use Symfony\Component\EventDispatcher\Event;

class ReceiveOrderEvent extends Event
{
    const EVENT_NAME = 'event.widget.payment.receive.order';

    /** @var string  */
    protected $ordernumber;
    /** @var int  */
    protected $amount;
    /** @var bool  */
    protected $status;
    /** @var mixed  */
    protected $originInfo;
    protected $paymentType;

    /**
     * ReceiveOrderEvent constructor.
     * @param string $ordernumber 訂單編號
     * @param integer $amount 金額
     * @param boolean $status 付款成功狀態 (true/false)
     * @param mixed $originInfo
     */
    public function __construct($ordernumber, $amount, $status, $paymentType, $originInfo)
    {
        $this->ordernumber = $ordernumber;
        $this->amount = $amount;
        $this->status = $status;
        $this->originInfo = $originInfo;
        $this->paymentType = $paymentType;
    }

    /**
     * @return string
     */
    public function getOrdernumber()
    {
        return $this->ordernumber;
    }

    /**
     * @return integer
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * 付款狀態
     *  true 成功
     *  false 失敗
     * @return boolean
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @return mixed
     */
    public function getOriginInfo()
    {
        return $this->originInfo;
    }

    /**
     * @return mixed
     */
    public function getPaymentType()
    {
        return $this->paymentType;
    }

}