<?php
namespace Widget\PaymentBundle\Event;

use Symfony\Component\EventDispatcher\Event;
use Widget\PaymentBundle\Processer\ProcesserResult;

class ProcessPaymentEvent extends Event
{
    const EVENT_NAME = 'event.widget.payment.process.event';

    protected $paymentType;
    protected $ordernumber;
    protected $amount;
    protected $paymentExtraInfo;

    /** @var  ProcesserResult */
    protected $result;

    public function __construct($paymentType, $ordernumber, $amount, $paymentExtraInfo)
    {
        $this->result = new ProcesserResult();
        $this->paymentType = $paymentType;
        $this->ordernumber = $ordernumber;
        $this->amount = $amount;
        $this->paymentExtraInfo = $paymentExtraInfo;
    }

    /**
     * @return ProcesserResult
     */
    public function getProcesserResult()
    {
        return $this->result;
    }

    public function getPaymentType()
    {
        return $this->paymentType;
    }

    public function getOrdernumber()
    {
        return $this->ordernumber;
    }

    public function getAmount()
    {
        return $this->amount;
    }

    public function getPaymentExtraInfo()
    {
        return $this->paymentExtraInfo;
    }
}