<?php
namespace Widget\PaymentBundle\Event;

use Symfony\Component\EventDispatcher\Event;
use Widget\PaymentBundle\Processer\ProcesserBase;

class GetProcesserEvent extends Event
{
    const EVENT_NAME = 'event.widget.payment.get.processer';

    protected $paymentType;

    /** @var  ProcesserBase */
    protected $processer;

    public function __construct($paymentType)
    {
        $this->paymentType = $paymentType;
    }

    public function getPaymentType()
    {
        return $this->paymentType;
    }

    public function setProcesser(ProcesserBase $processer)
    {
        $this->processer = $processer;
    }

    /**
     * @return ProcesserBase
     */
    public function getProcesser()
    {
        return $this->processer;
    }
}