<?php
namespace Widget\PaymentBundle\Controller\API;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Widget\PaymentBundle\Event\QueryAvailablePaymentEvent;
use Widget\PaymentBundle\Model\OrderReturnUrl;
use Widget\PaymentBundle\Model\OrderReturnUrlQuery;

/**
 * @Route("/payment")
 */
class PaymentController extends Controller
{
    /**
     * @Route("/")
     * @Method({"POST"})
     */
    public function payAction(Request $request)
    {
        $url = $request->request->get('return_url');
        $token = $request->request->get('token');
        $paymentType = $request->request->get('payment_type');
        
        $paymentToken = $this->get('widget_order.payment.token');
        $payment = $paymentToken->verifyToken($token);
        
        if(!$payment){
            throw $this->createNotFoundException();
        }

        $orderReturnUrl = OrderReturnUrlQuery::create()
            ->filterByOrdernumber($payment->ordernumber)
            ->findOneOrCreate();

        $orderReturnUrl
            ->setOrdernumber($payment->ordernumber)
            ->setReturnUrl($url)
            ->save();

        $result = $this->get('widget_payment.payment')->processPayment($paymentType, $payment->ordernumber, $payment->amount, $payment->info);
        
        if(!$result->isProcessed()){
            throw $this->createNotFoundException();
        }

        return $result->makeResponse();
    }

    /**
     * 帶錢進來查有哪些可用金流
     * @Route("s")
     * @Method({"GET"})
     */
    public function readPaymentAction(Request $request)
    {
        $params = json_decode($request->getContent(), true);
        $event = new QueryAvailablePaymentEvent($params['amount']);
        return $event->getAvailablePayment();
    }
}