<?php
namespace Widget\PaymentBundle\Command;

use Propel\Bundle\PropelBundle\Command\DatabaseCreateCommand;
use Symfony\Bundle\FrameworkBundle\Command\AbstractConfigCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Widget\PaymentBundle\Event\CommandPollingEvent;

class PollingCommand extends AbstractConfigCommand
{
    /**
     * @see Command
     */
    protected function configure()
    {
        $this
            ->setDescription('金流模組輪詢機制')
            ->setName('dgfactor:payment:polling');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $event = new CommandPollingEvent($input, $output);
        $eventDispatcher = $this->getContainer()->get('event_dispatcher');
        $eventDispatcher->dispatch(CommandPollingEvent::EVENT_NAME, $event);
    }
}