<?php
namespace Widget\PaymentBundle\Command;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Widget\PaymentBundle\Event\PaymentExpiredEvent;
use Widget\PaymentBundle\Model\PaymentPeer;
use Widget\PaymentBundle\Model\PaymentQuery;
use Widget\PaymentBundle\Model\Payment;

class PaymentExpireCommand extends ContainerAwareCommand
{
    protected function configure()
    {
        $this
            ->setName('dgfactor:payment:expire')
            ->setDescription('建立過期未付款回收排程')
            ->setHelp(<<<EOT
The <info>dgfactor:payment:expire</info> 建立過期未付款回收排程:

  <info>php app/console dgfactor:payment:expire</info>
EOT
            );

    }

    /**
     * @see Command
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $eventDispatcher = $this->getContainer()->get('event_dispatcher');

        $con = \Propel::getConnection();
        $con->query("SET TRANSACTION ISOLATION LEVEL SERIALIZABLE;");

        $payments = PaymentQuery::create()
            ->filterByPaymentStatus(PaymentPeer::PAYMENT_STATUS_INITIAL)
            ->filterByPaymentExpiredAt(time(), \Criteria::LESS_THAN)
            ->find();
        ;

        /** @var Payment $payment */
        foreach ($payments as $payment){
            $con->beginTransaction();
            $event = new PaymentExpiredEvent($payment->getOrder($con), $con);
            $eventDispatcher->dispatch(PaymentExpiredEvent::EVENT_NAME, $event);
            $con->commit();
        }
    }
}