<?php
namespace Widget\Payment\SpgatewayBundle\Tests\Processer\Base;

use Backend\BaseBundle\Tests\Fixture\BaseKernelTestCase;
use Widget\Payment\SpgatewayBundle\Lib\AESCrypt;
use Widget\Payment\SpgatewayBundle\Lib\ShaHash;
use Widget\Payment\SpgatewayBundle\Processer\Base\BaseSpgatewayProcesser;

class BaseSpgatewayProcesserTest extends BaseKernelTestCase
{
    public function test_prepareHasher()
    {
        //arrange
        $config = array(
            'hash_key' => 'hash_key',
            'hash_iv' => 'hash_iv',
        );

        $mockSpgatewayProcesser = $this->getMockBuilder(BaseSpgatewayProcesser::class)
            ->getMockForAbstractClass();
        $this->setObjectAttribute($mockSpgatewayProcesser, 'config', $config);

        //act
        $this->callObjectMethod($mockSpgatewayProcesser, 'prepareHasher');

        //assert
        $this->assertInstanceOf(ShaHash::class, $this->getObjectAttribute($mockSpgatewayProcesser, 'shaHash'));
        $this->assertInstanceOf(AESCrypt::class, $this->getObjectAttribute($mockSpgatewayProcesser, 'crypt'));
    }

    public function test_verify_false()
    {
        //arrange
        $tradInfo = 'trad_info';
        $tradSha = 'trad_sha';

        $mockSpgatewayProcesser = $this->getMockBuilder(BaseSpgatewayProcesser::class)
            ->getMockForAbstractClass();
        $shaHash = $this->getMockBuilder(ShaHash::class)
            ->disableOriginalConstructor()
            ->setMethods(array('checkHash'))
            ->getMock();
        $shaHash
            ->expects($this->once())
            ->method('checkHash')
            ->with($tradInfo, $tradSha)
            ->willReturn(false)
        ;
        $this->setObjectAttribute($mockSpgatewayProcesser, 'shaHash', $shaHash);

        //act
        $result = $mockSpgatewayProcesser->verify($tradInfo, $tradSha);

        //assert
        $this->assertFalse($result);
    }

    public function test_verify_true()
    {
        //arrange
        $tradInfo = 'trad_info';
        $tradSha = 'trad_sha';
        $mockSpgatewayProcesser = $this->getMockBuilder(BaseSpgatewayProcesser::class)
            ->getMockForAbstractClass();
        $crypt = $this->getMockBuilder(AESCrypt::class)
            ->setMethods(array('decrypt'))
            ->disableOriginalConstructor()
            ->getMock();
        $crypt
            ->expects($this->once())
            ->method('decrypt')
            ->with($tradInfo)
            ->willReturn('{"a":"decrypt_content"}');

        $shaHash = $this->getMockBuilder(ShaHash::class)
            ->disableOriginalConstructor()
            ->setMethods(array('checkHash'))
            ->getMock();
        $shaHash
            ->expects($this->once())
            ->method('checkHash')
            ->with($tradInfo, $tradSha)
            ->willReturn(true)
        ;
        $this->setObjectAttribute($mockSpgatewayProcesser, 'shaHash', $shaHash);
        $this->setObjectAttribute($mockSpgatewayProcesser, 'crypt', $crypt);

        //act
        $result = $mockSpgatewayProcesser->verify($tradInfo, $tradSha);

        //assert
        $this->assertEquals(array('a' => 'decrypt_content'), $result);
    }
}