<?php
namespace Widget\Payment\SpgatewayBundle\Tests\Lib;

use Backend\BaseBundle\Tests\Fixture\BaseTestCase;
use Widget\Payment\SpgatewayBundle\Lib\ShaHash;

class ShaHashTest extends BaseTestCase
{
    public function test___construct()
    {
        //arrange
        $key = '123456';
        $iv = '654321';

        //act
        $checkmac = new ShaHash($key, $iv);

        //assert
        $this->assertEquals($key, $this->getObjectAttribute($checkmac, 'key'));
        $this->assertEquals($iv, $this->getObjectAttribute($checkmac, 'iv'));
    }

    public function test_createHash()
    {
        //arrange
        $key = '12345678901234567890123456789012';
        $iv = '1234567890123456';
        $hash = 'EA0A6CC37F40C1EA5692E7CBB8AE097653DF3E91365E6A9CD7E91312413C7BB8';
        $data = 'ff91c8aa01379e4de621a44e5f11f72e4d25bdb1a18242db6cef9ef07d80b0165e476fd1d9acaa53170272c82d122961e1a0700a7427cfa1cf90db7f6d6593bbc93102a4d4b9b66d9974c13c31a7ab4bba1d4e0790f0cbbbd7ad64c6d3c8012a601ceaa808bff70f94a8efa5a4f984b9d41304ffd879612177c622f75f4214fa';
        $shaHash = new ShaHash($key, $iv);

        //act
        $result = $shaHash->createHash($data);

        //assert
        $this->assertEquals($hash, $result);
    }

    public function test_checkHash_true()
    {
        //arrange
        $key = '12345678901234567890123456789012';
        $iv = '1234567890123456';
        $hash = 'EA0A6CC37F40C1EA5692E7CBB8AE097653DF3E91365E6A9CD7E91312413C7BB8';
        $data = 'ff91c8aa01379e4de621a44e5f11f72e4d25bdb1a18242db6cef9ef07d80b0165e476fd1d9acaa53170272c82d122961e1a0700a7427cfa1cf90db7f6d6593bbc93102a4d4b9b66d9974c13c31a7ab4bba1d4e0790f0cbbbd7ad64c6d3c8012a601ceaa808bff70f94a8efa5a4f984b9d41304ffd879612177c622f75f4214fa';
        $shaHash = new ShaHash($key, $iv);

        //act
        $result = $shaHash->checkHash($data, $hash);

        //assert
        $this->assertTrue($result);
    }

    public function test_checkHash_false()
    {
        //arrange
        $key = '12345678901234567890123456789012';
        $iv = '1234567890123456';
        $hash = 'EA0A6CC37F40C1EA5692E7CBB8AE097653DF3E91365E6A9CD7E91312413C7BB8';
        $data = 'ff91c8aa01379e4de621a44e5f11f72e4d25bdb1a18242db6cef9ef07d80b0165e476fd1d9acaa53170272c82d122961e1a0700a7427cfa1cf90db7f6d6593bbc93102a4d4b9b66d9974c13c31a7ab4bba1d4e0790f0cbbbd7ad64c6d3c8012a601ceaa808bff70f94a8efa5a4f984b9d41304ffd879612177c622f75f4214fa';
        $shaHash = new ShaHash($key, $iv);

        //act
        $result = $shaHash->checkHash($data, "badhash");

        //assert
        $this->assertFalse($result);
    }
}