<?php
namespace Widget\Payment\SpgatewayBundle\Tests\Lib;

use Backend\BaseBundle\Tests\Fixture\BaseTestCase;
use Widget\Payment\SpgatewayBundle\Lib\AESCrypt;

class AESCryptTest extends BaseTestCase
{
    public function test_encrypt()
    {
        //arrange
        $key = '12345678901234567890123456789012';
        $iv = '1234567890123456';
        $originInfo = array(
            'MerchantID' => '3430112',
            'RespondType' => 'JSON',
            'TimeStamp' => '1485232229',
            'Version' => '1.4',
            'MerchantOrderNo' => 'S_1485232229',
            'Amt' => '40',
            'ItemDesc' => 'UnitTest'
        );
        $plainText = http_build_query($originInfo);
        $encryptedText = 'ff91c8aa01379e4de621a44e5f11f72e4d25bdb1a18242db6cef9ef07d80b0165e476fd1d9acaa53170272c82d122961e1a0700a7427cfa1cf90db7f6d6593bbc93102a4d4b9b66d9974c13c31a7ab4bba1d4e0790f0cbbbd7ad64c6d3c8012a601ceaa808bff70f94a8efa5a4f984b9d41304ffd879612177c622f75f4214fa';
        $crypt = new AESCrypt($key, $iv);

        //act
        $result = $crypt->encrypt($plainText);

        //assert
        $this->assertEquals($encryptedText, $result);
    }

    public function test_decrypt()
    {
        $key = '12345678901234567890123456789012';
        $iv = '1234567890123456';
        $originInfo = array(
            'MerchantID' => '3430112',
            'RespondType' => 'JSON',
            'TimeStamp' => '1485232229',
            'Version' => '1.4',
            'MerchantOrderNo' => 'S_1485232229',
            'Amt' => '40',
            'ItemDesc' => 'UnitTest'
        );
        $plainText = http_build_query($originInfo);
        $encryptedText = 'ff91c8aa01379e4de621a44e5f11f72e4d25bdb1a18242db6cef9ef07d80b0165e476fd1d9acaa53170272c82d122961e1a0700a7427cfa1cf90db7f6d6593bbc93102a4d4b9b66d9974c13c31a7ab4bba1d4e0790f0cbbbd7ad64c6d3c8012a601ceaa808bff70f94a8efa5a4f984b9d41304ffd879612177c622f75f4214fa';
        $crypt = new AESCrypt($key, $iv);

        //act
        $result = $crypt->decrypt($encryptedText);

        //assert
        $this->assertEquals($plainText, $result);
    }

    public function test_decrypt2()
    {
        $key = '31LDkkBDcUHsYaZaHeDWho7ebCpxZqF6';
        $iv = 'J5UMXOGX0INgWUzA';
        $encryptedText = '289058e0442216ede7ef0505c0fa9697ba3579defee6e31b2cfbc974e5ca9adc1d96fb4690b951ede11510f6b3961bb9aa26d58469134384a1db0e69c1c4aa6f7ace92df58e0f1186ea7a5eb031cdecefce1c21136acd521e45114f594dea16c48f115bccd4a01d306703001b77e7194b2bdd10e267c421b436da76ceebcd58d450bc1e695721873339b629da6fa28b352921c27d011badd333c69bfeed1bbe5d29d3b541077312cccfa4290b3e9488187f25a00ef4f10f73a628631a6877d906fb41517d051ad54a2c6d8233adf58214e796eab7fd3f6236cb5ea8dc8b58a7752b109a3bcc685d4227945e6603cc50b32d2c1150a0bfb3bd6df31c2a669835f8740f5e64e440e6e3a9c0a11b0289bae3ea193a13fb1a53c6255ec7f5b22f0a00887f832e88916a8c632d9e3175630c7339d86bd099b150f04a2d33ef99d8726';
        $crypt = new AESCrypt($key, $iv);

        //act
        $result = $crypt->decrypt($encryptedText);

        //assert
        $this->assertNotEmpty($result);
    }

    public function test_addPKCS7Padding()
    {
        //arrange
        $data = '12345';
        $blockSize = 10;
        $resultData = '12345'.pack('CCCCC', 5, 5, 5, 5, 5);
        $crypt = $this->getMockBuilder(AESCrypt::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $this->setObjectAttribute($crypt, 'blockSize', $blockSize);

        //act
        $result = $this->callObjectMethod($crypt, 'addPKCS7Padding', $data);

        //assert
        $this->assertEquals($resultData, $result);
    }

    public function test_removePKCS7Padding()
    {
        //arrange
        $data = '12345'.pack('CCCCC', 5, 5, 5, 5, 5);
        $removePaddingData = '12345';
        $blockSize = 10;
        $crypt = $this->getMockBuilder(AESCrypt::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $this->setObjectAttribute($crypt, 'blockSize', $blockSize);

        //act
        $result = $this->callObjectMethod($crypt, 'removePKCS7Padding', $data);

        //assert
        $this->assertEquals($removePaddingData, $result);
    }
}
