<?php
namespace Widget\Payment\SpgatewayBundle\Processer;

use JMS\DiExtraBundle\Annotation as DI;
use Symfony\Component\Routing\Router;
use Widget\Payment\SpgatewayBundle\Processer\Base\BaseSpgatewayProcesser;
use Widget\PaymentBundle\Event\GetProcesserEvent;
use Widget\PaymentBundle\Event\ProcessPaymentEvent;
use Widget\PaymentBundle\Event\QueryAvailablePaymentEvent;

/**
 * 智付寶ATM虛擬帳戶付款金流模組
 * @DI\Service("widget_payment.processer.spgateway_vacc")
 */
class SpgatewayVaccProcesser extends BaseSpgatewayProcesser
{
    const PROCESSER_NAME = 'SpgatewayVacc';
    
    /**
     * @DI\InjectParams({
     *    "config" = @DI\Inject("widget_payment.config"),
     * })
     */
    public function injectConfig($config)
    {
        $this->config = (isset($config[self::PROCESSER_NAME])?$config[self::PROCESSER_NAME]:array());
        $this->prepareHasher();
    }

    /**
     * @DI\Observe(GetProcesserEvent::EVENT_NAME)
     */
    public function getProcesser(GetProcesserEvent $event)
    {
        if($event->getPaymentType() != static::PROCESSER_NAME){
            return;
        }

        $event->stopPropagation();
        $event->setProcesser($this);
    }

    /**
     * @DI\Observe(ProcessPaymentEvent::EVENT_NAME)
     */
    public function process(ProcessPaymentEvent $event)
    {
        if(!$this->config || $event->getPaymentType() != static::PROCESSER_NAME){
            return;
        }
        $event->stopPropagation();

        $params = $this->createPaymentParams($event->getOrdernumber(), $event->getAmount(), $event->getPaymentExtraInfo());

        $event->getProcesserResult()->setForwardPost(
            $this->config['gateway_url'] ,
            $params
        );
    }

    /**
     * @DI\Observe(QueryAvailablePaymentEvent::EVENT_NAME)
     */
    public function onQueryAvailablePaymentEvent(QueryAvailablePaymentEvent $event)
    {
        if($event->getAmount() < 10){
            return;
        }

        $event->addAvailablePayment(static::PROCESSER_NAME);
    }

    protected function getCurrentTime()
    {
        return new \DateTime();
    }

    protected function createTradInfo($ordernumber, $amount, $paymentExtraInfo)
    {
        return array(
            'MerchantID' => $this->config['store_id'],
            'RespondType' => 'JSON',
            'TimeStamp' => time(),
            'Version' => '1.4',
            'MerchantOrderNo' => $ordernumber,
            'Amt' => $amount,
            'LoginType' => 0,
            'ItemDesc' => $ordernumber,
            'ExpireDate' => $this->getCurrentTime()->modify("+{$this->config['expire_day']}days -1day")->format('Ymd'),
            'NotifyURL' => $this->router->generate('payment_spgateway_vacc_server_receive', array(), Router::ABSOLUTE_URL),
            'CustomerURL' => $this->router->generate('payment_spgateway_vacc_paymentinfo_receive', array(), Router::ABSOLUTE_URL),
            'ClientBackURL' => $this->router->generate('payment_spgateway_vacc_user_return', array('ordernumber' => $ordernumber), Router::ABSOLUTE_URL),
            'VACC' => 1,
        );
    }
}
