<?php
namespace Widget\Payment\SpgatewayBundle\Processer\Base;

use JMS\DiExtraBundle\Annotation as DI;
use Symfony\Component\Routing\Router;
use Widget\Payment\SpgatewayBundle\Lib\AESCrypt;
use Widget\Payment\SpgatewayBundle\Lib\ShaHash;
use Widget\PaymentBundle\Event\ProcessPaymentEvent;
use Widget\PaymentBundle\Event\QueryAvailablePaymentEvent;
use Widget\PaymentBundle\Processer\ProcesserBase;

abstract class BaseSpgatewayProcesser extends ProcesserBase
{
    protected $config;
    /** @var  Router */
    protected $router;
    /** @var  AESCrypt */
    protected $crypt;
    /** @var  ShaHash */
    protected $shaHash;

    abstract public function onQueryAvailablePaymentEvent(QueryAvailablePaymentEvent $event);
    abstract public function process(ProcessPaymentEvent $event);
    abstract protected function createTradInfo($ordernumber, $amount, $paymentExtraInfo);

    protected function prepareHasher()
    {
        $this->shaHash = new ShaHash($this->config['hash_key']??null, $this->config['hash_iv']??null);
        $this->crypt = new AESCrypt($this->config['hash_key']??null, $this->config['hash_iv']??null);
    }
    
    public function verify($tradInfo, $tradSha)
    {
        if($this->shaHash->checkHash($tradInfo, $tradSha) === false){
            return false;
        }

        return json_decode($this->crypt->decrypt($tradInfo), true);
    }

    /**
     * @DI\InjectParams()
     */
    public function injectRoute(Router $router)
    {
        $this->router = $router;
    }

    protected function createPaymentParams($ordernumber, $amount, $paymentExtraInfo)
    {
        $tradInfo = http_build_query($this->createTradInfo($ordernumber, $amount, $paymentExtraInfo));
        $cryptTradInfo = $this->crypt->encrypt($tradInfo);
        $tradInfoHash = $this->shaHash->createHash($cryptTradInfo);

        return array(
            'MerchantID' => $this->config['store_id'],
            'TradeInfo' => $cryptTradInfo,
            'TradeSha' => $tradInfoHash,
            'Version' => '1.4',
        );
    }


}