<?php
namespace Widget\Payment\SpgatewayBundle\Lib;

class AESCrypt
{
    protected $iv;
    protected $key;
    protected $blockSize = 32;
    protected $cipher = 'AES-256-CBC';

    public function __construct($key, $iv = null)
    {
        if($iv === null){
            $size = openssl_cipher_iv_length($this->cipher);
            $iv = openssl_random_pseudo_bytes($size);
        }
        $this->key = $key;
        $this->iv = $iv;
    }

    public function encrypt($plainData)
    {
        return bin2hex(openssl_encrypt($this->addPKCS7Padding($plainData), $this->cipher, $this->key, OPENSSL_RAW_DATA|OPENSSL_ZERO_PADDING, $this->iv));
    }

    protected function addPKCS7Padding($data)
    {
        $paddingSize = $this->blockSize - (strlen($data) % $this->blockSize);
        $data .= str_repeat(chr($paddingSize), $paddingSize);
        return $data;
    }

    protected function removePKCS7Padding($data)
    {
        $len = strlen($data);
        $paddingSize = ord($data[$len-1]);
        return substr($data, 0, $len - $paddingSize);
    }

    public function decrypt($encryptData)
    {
        return $this->removePKCS7Padding(openssl_decrypt(hex2bin($encryptData), $this->cipher, $this->key, OPENSSL_RAW_DATA|OPENSSL_ZERO_PADDING, $this->iv));
    }
}