<?php
namespace Widget\Payment\SpgatewayBundle\Controller\Front;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Widget\PaymentBundle\Event\ReceiveOrderEvent;
use Widget\PaymentBundle\Event\ReceivePaymentnumberEvent;
use Widget\PaymentBundle\Event\ReturnUrlEvent;

/**
 * 智付通ATM虛擬帳號金流處理
 * @Route("/v")
 */
class SpgatewayVaccController extends Controller
{

    /**
     * ATM虛擬帳號 接收訂單授權結果 (server to server) callback
     * @Route("/s/r", name="payment_spgateway_vacc_server_receive")
     */
    public function vaccReceiveOrderAction(Request $request)
    {
        $params = $request->request->all();
        $config = $this->get('widget_payment.config');

        if(!$config || !isset($config['SpgatewayVacc']) || $config['SpgatewayVacc']['store_id'] != $params['MerchantID']){
            throw $this->createNotFoundException();
        }

        $processer = $this->get('widget_payment.payment')->getProcesser('SpgatewayVacc');

        $result = $processer->verify($params['TradeInfo']??null, $params['TradeSha']??null);

        if($result === false){
            throw $this->createNotFoundException();
        }
        
        $event = new ReceiveOrderEvent($result['Result']['MerchantOrderNo'], $result['Result']['Amt'], $result['Status'] == 'SUCCESS', 'SpgatewayVacc', $result);
        $processer->emitReceiveOrder($event);

        return new Response();
    }

    /**
     * ATM虛擬帳號 取消 User 返回 (user to server) callback
     * @Route("/u/r/{ordernumber}", name="payment_spgateway_vacc_user_return")
     */
    public function vaccUserReturnAction($ordernumber)
    {
        $processer = $this->get('widget_payment.payment')->getProcesser('SpgatewayVacc');
        $event = new ReturnUrlEvent($ordernumber);
        $processer->emitReturnUrl($event);
        $url = $event->getUrl();
        if($url == null){
            throw $this->createNotFoundException();
        }
        return $this->redirect($url);
    }


    /**
     * vacc 接收付款條碼
     * @Route("/p/r", name="payment_spgateway_vacc_paymentinfo_receive")
     */
    public function vaccReceivePaymentInfoAction(Request $request)
    {
        $params = $request->request->all();
        $config = $this->get('widget_payment.config');

        if(!$config || !isset($config['SpgatewayVacc']) || $config['SpgatewayVacc']['store_id'] != $params['MerchantID']){
            throw $this->createNotFoundException();
        }

        $processer = $this->get('widget_payment.payment')->getProcesser('SpgatewayVacc');
        $result = $processer->verify($params['TradeInfo']??null, $params['TradeSha']??null);

        if($result === false){
            throw $this->createNotFoundException();
        }

        if($result['Status'] ==  'SUCCESS'){
            $receivePaymentnumberEvent = new ReceivePaymentnumberEvent($result['Result']['MerchantOrderNo'], "{$result['Result']['BankCode']}-{$result['Result']['CodeNo']}", new \DateTime("{$result['Result']['ExpireDate']} {$result['Result']['ExpireTime']}"), $result);
        }
        else{
            $receivePaymentnumberEvent = new ReceivePaymentnumberEvent($result['Result']['MerchantOrderNo'], null, new \DateTime(), $result);
        }

        $processer->emitReceivePaymentnumber($receivePaymentnumberEvent);

        $event = new ReturnUrlEvent($result['Result']['MerchantOrderNo']);
        $processer->emitReturnUrl($event);
        $url = $event->getUrl();
        if($url == null){
            throw $this->createNotFoundException();
        }
        return $this->redirect($url);
    }
}
