<?php
namespace Widget\Payment\SpgatewayBundle\Controller\Front;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Widget\PaymentBundle\Event\ReceiveOrderEvent;
use Widget\PaymentBundle\Event\ReceivePaymentnumberEvent;
use Widget\PaymentBundle\Event\ReturnUrlEvent;

/**
 * 智付通超商代碼金流處理
 * @Route("/s")
 */
class SpgatewayCvsController extends Controller
{

    /**
     * 超商代碼 接收訂單授權結果 (server to server) callback
     * @Route("/s/r", name="payment_spgateway_cvs_server_receive")
     */
    public function cvsReceiveOrderAction(Request $request)
    {
        $params = $request->request->all();
        $config = $this->get('widget_payment.config');

        if(!$config || !isset($config['SpgatewayCvs']) || $config['SpgatewayCvs']['store_id'] != $params['MerchantID']){
            throw $this->createNotFoundException();
        }

        $processer = $this->get('widget_payment.payment')->getProcesser('SpgatewayCvs');

        $result = $processer->verify($params['TradeInfo']??null, $params['TradeSha']??null);

        if($result === false){
            throw $this->createNotFoundException();
        }
        
        $event = new ReceiveOrderEvent($result['Result']['MerchantOrderNo'], $result['Result']['Amt'], $result['Status'] == 'SUCCESS', 'SpgatewayCvs', $result);
        $processer->emitReceiveOrder($event);

        return new Response();
    }

    /**
     * 超商代碼 取消 User 返回 (user to server) callback
     * @Route("/u/r/{ordernumber}", name="payment_spgateway_cvs_user_return")
     */
    public function cvsUserReturnAction($ordernumber)
    {
        $processer = $this->get('widget_payment.payment')->getProcesser('SpgatewayCvs');
        $event = new ReturnUrlEvent($ordernumber);
        $processer->emitReturnUrl($event);
        $url = $event->getUrl();
        if($url == null){
            throw $this->createNotFoundException();
        }
        return $this->redirect($url);
    }


    /**
     * cvs 接收付款條碼
     * @Route("/p/r", name="payment_spgateway_cvs_paymentinfo_receive")
     */
    public function cvsReceivePaymentInfoAction(Request $request)
    {
        $params = $request->request->all();
        $config = $this->get('widget_payment.config');

        if(!$config || !isset($config['SpgatewayCvs']) || $config['SpgatewayCvs']['store_id'] != $params['MerchantID']){
            throw $this->createNotFoundException();
        }

        $processer = $this->get('widget_payment.payment')->getProcesser('SpgatewayCvs');
        $result = $processer->verify($params['TradeInfo']??null, $params['TradeSha']??null);

        if($result === false){
            throw $this->createNotFoundException();
        }

        if($result['Status'] ==  'SUCCESS'){
            $receivePaymentnumberEvent = new ReceivePaymentnumberEvent($result['Result']['MerchantOrderNo'], $result['Result']['CodeNo'], new \DateTime("{$result['Result']['ExpireDate']} {$result['Result']['ExpireTime']}"), $result);
        }
        else{
            $receivePaymentnumberEvent = new ReceivePaymentnumberEvent($result['Result']['MerchantOrderNo'], null, new \DateTime(), $result);
        }

        $processer->emitReceivePaymentnumber($receivePaymentnumberEvent);

        $event = new ReturnUrlEvent($result['Result']['MerchantOrderNo']);
        $processer->emitReturnUrl($event);
        $url = $event->getUrl();
        if($url == null){
            throw $this->createNotFoundException();
        }
        return $this->redirect($url);
    }
}
