<?php
namespace Widget\Payment\SpgatewayBundle\Controller\Front;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Widget\PaymentBundle\Event\ReceiveOrderEvent;
use Widget\PaymentBundle\Event\ReceivePaymentnumberEvent;
use Widget\PaymentBundle\Event\ReturnUrlEvent;

/**
 * 智付通信用卡金流處理
 * @Route("/c")
 */
class SpgatewayCreditController extends Controller
{

    /**
     * 信用卡 接收訂單授權結果 (server to server) callback
     * @Route("/s/r", name="payment_spgateway_credit_server_receive")
     */
    public function creditReceiveOrderAction(Request $request)
    {
        $params = $request->request->all();
        $config = $this->get('widget_payment.config');

        if(!$config || !isset($config['SpgatewayCredit']) || $config['SpgatewayCredit']['store_id'] != $params['MerchantID']){
            throw $this->createNotFoundException();
        }

        $processer = $this->get('widget_payment.payment')->getProcesser('SpgatewayCredit');

        $result = $processer->verify($params['TradeInfo']??null, $params['TradeSha']??null);

        if($result === false){
            throw $this->createNotFoundException();
        }
        
        $event = new ReceiveOrderEvent($result['Result']['MerchantOrderNo'], $result['Result']['Amt'], $result['Status'] == 'SUCCESS', 'SpgatewayCredit', $result);
        $processer->emitReceiveOrder($event);

        return new Response();
    }

    /**
     * 信用卡 刷卡完成 User 返回 (user to server) callback
     * @Route("/u/r/{ordernumber}", name="payment_spgateway_credit_user_return")
     */
    public function creditUserReturnAction($ordernumber)
    {
        $processer = $this->get('widget_payment.payment')->getProcesser('SpgatewayCredit');
        $event = new ReturnUrlEvent($ordernumber);
        $processer->emitReturnUrl($event);
        $url = $event->getUrl();
        if($url == null){
            throw $this->createNotFoundException();
        }
        return $this->redirect($url);
    }

}