<?php
namespace Widget\Payment\SpgatewayBundle\Controller\Front;

use JMS\DiExtraBundle\Annotation\Inject;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Widget\Payment\SpgatewayBundle\Processer\SpgatewayBarcodeProcesser;
use Widget\PaymentBundle\Event\ReceiveOrderEvent;
use Widget\PaymentBundle\Event\ReceivePaymentnumberEvent;
use Widget\PaymentBundle\Event\ReturnUrlEvent;

/**
 * 智付通超商條碼金流處理
 * @Route("/b")
 */
class SpgatewayBarcodeController extends Controller
{

    /**
     * @Inject("widget_payment.processer.spgateway_barcode")
     * @var SpgatewayBarcodeProcesser
     */
    protected $processer;

    /**
     * 超商條碼列印
     * @Route("/{ordernumber}/print", name="payment_spgateway_barcode_print")
     */
    public function barcodePrintAction($ordernumber)
    {
        return $this->redirect($this->processer->getBarCodePrintUrl($ordernumber));
    }

    /**
     * 超商條碼 接收訂單授權結果 (server to server) callback
     * @Route("/s/r", name="payment_spgateway_barcode_server_receive")
     */
    public function barcodeReceiveOrderAction(Request $request)
    {
        $params = $request->request->all();
        $config = $this->get('widget_payment.config');

        if(!$config || !isset($config['SpgatewayBarcode']) || $config['SpgatewayBarcode']['store_id'] != $params['MerchantID']){
            throw $this->createNotFoundException();
        }

        $processer = $this->get('widget_payment.payment')->getProcesser('SpgatewayBarcode');

        $result = $processer->verify($params['TradeInfo']??null, $params['TradeSha']??null);

        if($result === false){
            throw $this->createNotFoundException();
        }

        $event = new ReceiveOrderEvent($result['Result']['MerchantOrderNo'], $result['Result']['Amt'], $result['Status'] == 'SUCCESS', 'SpgatewayBarcode', $result);
        $processer->emitReceiveOrder($event);

        return new Response();
    }

    /**
     * 超商條碼 取消 User 返回 (user to server) callback
     * @Route("/u/r/{ordernumber}", name="payment_spgateway_barcode_user_return")
     */
    public function barcodeUserReturnAction($ordernumber)
    {
        $processer = $this->get('widget_payment.payment')->getProcesser('SpgatewayBarcode');
        $event = new ReturnUrlEvent($ordernumber);
        $processer->emitReturnUrl($event);
        $url = $event->getUrl();
        if($url == null){
            throw $this->createNotFoundException();
        }
        return $this->redirect($url);
    }


    /**
     * barcode 接收付款條碼
     * @Route("/p/r", name="payment_spgateway_barcode_paymentinfo_receive")
     */
    public function barcodeReceivePaymentInfoAction(Request $request)
    {
        $params = $request->request->all();
        $config = $this->get('widget_payment.config');

        if(!$config || !isset($config['SpgatewayBarcode']) || $config['SpgatewayBarcode']['store_id'] != $params['MerchantID']){
            throw $this->createNotFoundException();
        }

        $processer = $this->get('widget_payment.payment')->getProcesser('SpgatewayBarcode');
        $result = $processer->verify($params['TradeInfo']??null, $params['TradeSha']??null);

        if($result === false){
            throw $this->createNotFoundException();
        }

        if($result['Status'] ==  'SUCCESS'){
            $receivePaymentnumberEvent = new ReceivePaymentnumberEvent($result['Result']['MerchantOrderNo'], "{$result['Result']['Barcode_1']} {$result['Result']['Barcode_2']} {$result['Result']['Barcode_3']}", new \DateTime("{$result['Result']['ExpireDate']} {$result['Result']['ExpireTime']}"), $result);
        }
        else{
            $receivePaymentnumberEvent = new ReceivePaymentnumberEvent($result['Result']['MerchantOrderNo'], null, new \DateTime(), $result);
        }

        $processer->emitReceivePaymentnumber($receivePaymentnumberEvent);

        $event = new ReturnUrlEvent($result['Result']['MerchantOrderNo']);
        $processer->emitReturnUrl($event);
        $url = $event->getUrl();
        if($url == null){
            throw $this->createNotFoundException();
        }
        return $this->redirect($url);
    }
}
