<?php
namespace Widget\Payment\PayAfterBundle\Tests\Processer\PayAfter;

use Backend\BaseBundle\Tests\Fixture\BaseTestCase;
use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Symfony\Component\EventDispatcher\EventDispatcher;
use Widget\OrderBundle\Model\OrderQuery;
use Widget\PaymentBundle\Event\ProcessPaymentEvent;
use Widget\PaymentBundle\Event\QueryAvailablePaymentEvent;
use Widget\PaymentBundle\Event\ReturnUrlEvent;
use Widget\Payment\PayAfterBundle\Processer\PayAfter\PayAfterATMProcesser;
use Widget\PaymentBundle\Processer\ProcesserBase;

class PayAfterATMProcesserTest extends BaseWebTestCase
{
    public function test_injectConfig()
    {
        //arrange
        $config = array(
            'PayAfterATM' => array(
                'expire_day'     => '2016/02/21 00:00:00',
            ),
        );
        $processer = $this->getMockForAbstractClass(PayAfterATMProcesser::class);

        //act
        $processer->injectConfig($config);

        //assert
        $this->assertEquals($config['PayAfterATM'], $this->getObjectAttribute($processer, 'config'));
    }

    public function test_process_bad_paymentType()
    {
        //arrange
        $ordernumber = 'o12345';
        $amount = 123;
        $paymentInfo = array('a', 'b', 'c');
        $processer = $this->getMockBuilder(PayAfterATMProcesser::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $config = array(
            'expire_day'     => '2016/02/21 00:00:00',
        );
        $this->setObjectAttribute($processer, 'config', $config);
        $event = new ProcessPaymentEvent('BadATM', $ordernumber, $amount, $paymentInfo);

        //act
        $processer->process($event);
        $result = $event->getProcesserResult();

        //assert
        $this->assertFalse($result->isProcessed());
    }
    
    public function test_process_ok()
    {
        // arrange
        $paymentType = PayAfterATMProcesser::PROCESSER_NAME;
        $ordernumber = OrderQuery::create()->findOne()->getId();
        $amount = 500;
        $paymentExtraInfo = array('a' => 'ABC' , 'paymentInfoText' => 'test payment info text');
        $config = array(
            'expire_day'     => 3,
        );

        $processer = $this->getMockBuilder(PayAfterATMProcesser::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $dispatcher = $this->getMockBuilder(EventDispatcher::class)
            ->setMethods(array('dispatch'))
            ->getMock();
        $dispatcher
            ->expects($this->exactly(2))
            ->method('dispatch')
            ->willReturn('132456');

        $event = new ProcessPaymentEvent($paymentType, $ordernumber, $amount, $paymentExtraInfo);
        $returnURL = new ReturnUrlEvent($event->getOrdernumber());
        $this->setObjectAttribute($processer, 'config', $config, ProcesserBase::class);
        $this->setObjectAttribute($processer, 'dispatcher', $dispatcher, ProcesserBase::class);

        // act
        $processer->process($event);

        $result = $event->getProcesserResult()->setForwardRedirect($returnURL->getUrl());

        // assert
        $this->assertTrue($result->isProcessed());
        
    }

    public function test_onQueryAvailablePaymentEvent()
    {
        // arrange
        $processer = $this->getMockBuilder(PayAfterATMProcesser::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $event = $this->getMockBuilder(QueryAvailablePaymentEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();

        // act
        $processer->onQueryAvailablePaymentEvent($event);
        $result = $event->getAvailablePayment();

        // asset
        $this->assertEquals(array('PayAfterATM'), $result);
    }

}
