<?php
namespace Widget\Payment\PayAfterBundle\Processer\PayAfter;

use JMS\DiExtraBundle\Annotation as DI;
use Widget\OrderBundle\Model\OrderQuery;
use Widget\OrderBundle\Event\ReceiveCreateOrderEvent;
use Widget\PaymentBundle\Event\GetProcesserEvent;
use Widget\PaymentBundle\Event\ProcessPaymentEvent;
use Widget\PaymentBundle\Event\QueryAvailablePaymentEvent;
use Widget\PaymentBundle\Event\ReceivePaymentAfterCODEvent;
use Widget\PaymentBundle\Event\ReceivePaymentnumberEvent;
use Widget\PaymentBundle\Event\ReturnUrlEvent;
use Widget\PaymentBundle\Model\PaymentQuery;
use Widget\PaymentBundle\Processer\ProcesserBase;

/**
 * 歐付寶虛擬帳號付款金流模組
 * @DI\Service("widget_payment.processer.payafter_cod")
 */
class PayAfterCODProcesser extends ProcesserBase
{

    const PROCESSER_NAME = 'PayAfterCOD';
    
    /**
     * @DI\InjectParams({
     *    "config" = @DI\Inject("widget_payment.config"),
     * })
     */
    public function injectConfig($config)
    {
        $this->config = (isset($config[self::PROCESSER_NAME])?$config[self::PROCESSER_NAME]:array());
    }

    /**
     * @DI\Observe(GetProcesserEvent::EVENT_NAME)
     */
    public function getProcesser(GetProcesserEvent $event)
    {
        if($event->getPaymentType() != self::PROCESSER_NAME){
            return;
        }

        $event->stopPropagation();
        $event->setProcesser($this);
    }

    /**
     * @DI\Observe(ProcessPaymentEvent::EVENT_NAME)
     */
    public function process(ProcessPaymentEvent $event)
    {
        if ($event->getPaymentType() != self::PROCESSER_NAME) {
            return;
        }
        
        $event->stopPropagation();
        $receiveCreateOrderEvent = new ReceiveCreateOrderEvent(
            OrderQuery::create()->findPk($event->getOrdernumber())
        );
        $this->emitReceiveCreateOrder($receiveCreateOrderEvent);
        
        $returnUrlEvent = new ReturnUrlEvent($event->getOrdernumber());
        $this->emitReturnUrl($returnUrlEvent);
        $event->getProcesserResult()->setForwardRedirect($returnUrlEvent->getUrl());
    }

    /**
     * @DI\Observe(QueryAvailablePaymentEvent::EVENT_NAME)
     */
    public function onQueryAvailablePaymentEvent(QueryAvailablePaymentEvent $event)
    {
        $event->addAvailablePayment(self::PROCESSER_NAME);
    }
    
}