<?php
namespace Widget\Payment\DigiflowBundle\Tests\Lib;

use Backend\BaseBundle\Tests\Fixture\BaseTestCase;
use Widget\Payment\DigiflowBundle\Lib\ShaHash;

class ShaHashTest extends BaseTestCase
{
    public function test___construct()
    {
        //arrange
        $key = 'test_key';

        //act
        $shaHash = new ShaHash($key);

        //assert
        $this->assertEquals($key, $this->getObjectAttribute($shaHash, 'key'));
    }

    public function test_createHash()
    {
        //arrange
        $hash = 'Wve/GBwR/D0xSudNKj6jYIdXYRkijU4N8765/L9ZtIo=';
        $key = '32C10AF937295BB8A414D36A45AD9DF0856FE78B1966F782C3A1E2F5BCCA634E';
        $data = array(
            'buyer_mail' => 'cs@digiflowtech.com',
            'currency' => 'TWD',
            'expiry_time' => '20170407161609',
            'ext_data' => 'AP01',
            'merchant_id' => '123456789012345',
            'order_amount' => 10000,
            'order_desc' => '商品名稱',
            'order_no' => 'ON2016110100001',
            'terminal_id' => 12345678,
            'timestamp' => 1491549369718,
            'version' => '1.0',
        );
        $shaHash = new ShaHash($key);

        //act
        $result = $shaHash->createHash($this->ashuffle($data));

        //assert
        $this->assertEquals($hash, $result);
    }

    protected function ashuffle ($arr)
    {
        $result = array();
        $keys = array_keys($arr);
        shuffle($keys);
        foreach ($keys as $key){
            $result[$key] = $arr[$key];
        }
        return $result;
    }

    public function test_checkHash_true()
    {
        //arrange
        $hash = '12345';
        $data = array(
            'test_data',
        );
        $shaHash = $this->getMockBuilder(ShaHash::class)
            ->disableOriginalConstructor()
            ->setMethods(array('createHash'))
            ->getMock();
        $shaHash
            ->expects($this->once())
            ->method('createHash')
            ->with($data)
            ->willReturn($hash);

        //act
        $result = $shaHash->checkHash($data, $hash);

        //assert
        $this->assertTrue($result);
    }

    public function test_checkHash_false()
    {
        //arrange
        $hash = '12345';
        $data = array(
            'test_data',
        );
        $shaHash = $this->getMockBuilder(ShaHash::class)
            ->disableOriginalConstructor()
            ->setMethods(array('createHash'))
            ->getMock();
        $shaHash
            ->expects($this->once())
            ->method('createHash')
            ->with($data)
            ->willReturn('bad_hash');

        //act
        $result = $shaHash->checkHash($data, $hash);

        //assert
        $this->assertFalse($result);
    }
}