<?php
namespace Widget\Payment\DigiflowBundle\Tests\Controller\Front;

use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Widget\Payment\DigiflowBundle\Event\QuertPaymentResultEvent;
use Widget\Payment\DigiflowBundle\Processer\DigiflowCreditProcesser;
use Widget\PaymentBundle\Event\GetProcesserEvent;
use Widget\PaymentBundle\Event\ReturnUrlEvent;

class DigiflowControllerTest extends BaseWebTestCase
{
    public function test_userReturnAction_ext_data_驗證錯誤()
    {
        //arrange
        $url = 'http://foo.bar/';
        $extData = 'ext_data';
        $ordernumber = 'A12345';
        $eventFired = array();
        $params = array(
            'order_no' => $ordernumber,
            'ext_data' => $extData,
        );
        $result = array(
            'return_code' => '000000',
            'return_msg' => 'ok',
        );

        $processer = $this->getMockBuilder(DigiflowCreditProcesser::class)
            ->setMethods(array('verify'))
            ->getMock();

        $processer
            ->expects($this->once())
            ->method('verify')
            ->with($ordernumber, $extData)
            ->willReturn(false);

        $dispatcher = $this->client->getContainer()->get('event_dispatcher');

        $dispatcher->addListener(GetProcesserEvent::EVENT_NAME, function(GetProcesserEvent $event) use($processer, &$eventFired){
            $eventFired[] = GetProcesserEvent::EVENT_NAME;
            $event->setProcesser($processer);
            $event->stopPropagation();
        }, 99999);

        $dispatcher->addListener(QuertPaymentResultEvent::EVENT_NAME, function(QuertPaymentResultEvent $event) use($result, &$eventFired){
            $eventFired[] = QuertPaymentResultEvent::EVENT_NAME;
            $this->assertEquals($result, $event->getQueryPaymentResult());
            $event->stopPropagation();
        }, 99999);

        $dispatcher->addListener(ReturnUrlEvent::EVENT_NAME, function(ReturnUrlEvent $event) use($url, &$eventFired){
            $eventFired[] = ReturnUrlEvent::EVENT_NAME;
            $event->setUrl($url);
            $event->stopPropagation();
        }, 99999);

        //act
        $this->client->request(
            'POST',
            $this->generateUrl('payment_digiflow_user_return'),
            $params
        );
        $response = $this->client->getResponse();

        //assert
        $this->assertTrue($response->isRedirect($url));
        $this->assertEquals(array(GetProcesserEvent::EVENT_NAME, ReturnUrlEvent::EVENT_NAME), $eventFired);
    }

    public function test_userReturnAction_找不到_return_url()
    {
        //arrange
        $url = 'http://foo.bar/';
        $extData = 'ext_data';
        $ordernumber = 'A12345';
        $eventFired = array();
        $params = array(
            'order_no' => $ordernumber,
            'ext_data' => $extData,
        );
        $result = array(
            'return_code' => '000000',
            'return_msg' => 'ok',
        );

        $processer = $this->getMockBuilder(DigiflowCreditProcesser::class)
            ->setMethods(array('verify'))
            ->getMock();

        $processer
            ->expects($this->once())
            ->method('verify')
            ->with($ordernumber, $extData)
            ->willReturn(false);

        $dispatcher = $this->client->getContainer()->get('event_dispatcher');

        $dispatcher->addListener(GetProcesserEvent::EVENT_NAME, function(GetProcesserEvent $event) use($processer, &$eventFired){
            $eventFired[] = GetProcesserEvent::EVENT_NAME;
            $event->setProcesser($processer);
            $event->stopPropagation();
        }, 99999);

        $dispatcher->addListener(QuertPaymentResultEvent::EVENT_NAME, function(QuertPaymentResultEvent $event) use($result, &$eventFired){
            $eventFired[] = QuertPaymentResultEvent::EVENT_NAME;
            $this->assertEquals($result, $event->getQueryPaymentResult());
            $event->stopPropagation();
        }, 99999);

        $dispatcher->addListener(ReturnUrlEvent::EVENT_NAME, function(ReturnUrlEvent $event) use($url, &$eventFired){
            $eventFired[] = ReturnUrlEvent::EVENT_NAME;
            $event->stopPropagation();
        }, 99999);

        //act
        $this->client->request(
            'POST',
            $this->generateUrl('payment_digiflow_user_return'),
            $params
        );
        $response = $this->client->getResponse();

        //assert
        $this->assertTrue($response->isNotFound());
        $this->assertEquals(array(GetProcesserEvent::EVENT_NAME, ReturnUrlEvent::EVENT_NAME), $eventFired);
    }

    public function test_userReturnAction()
    {

        //arrange
        $url = 'http://foo.bar/';
        $extData = 'ext_data';
        $ordernumber = 'A12345';
        $eventFired = array();
        $params = array(
            'order_no' => $ordernumber,
            'ext_data' => $extData,
        );
        $result = array(
            'return_code' => '000000',
            'return_msg' => 'ok',
        );

        $processer = $this->getMockBuilder(DigiflowCreditProcesser::class)
            ->setMethods(array('verify'))
            ->getMock();

        $processer
            ->expects($this->once())
            ->method('verify')
            ->with($ordernumber, $extData)
            ->willReturn($result);

        $dispatcher = $this->client->getContainer()->get('event_dispatcher');

        $dispatcher->addListener(GetProcesserEvent::EVENT_NAME, function(GetProcesserEvent $event) use($processer, &$eventFired){
            $eventFired[] = GetProcesserEvent::EVENT_NAME;
            $event->setProcesser($processer);
            $event->stopPropagation();
        }, 99999);

        $dispatcher->addListener(QuertPaymentResultEvent::EVENT_NAME, function(QuertPaymentResultEvent $event) use($result, &$eventFired){
            $eventFired[] = QuertPaymentResultEvent::EVENT_NAME;
            $this->assertEquals($result, $event->getQueryPaymentResult());
            $event->stopPropagation();
        }, 99999);

        $dispatcher->addListener(ReturnUrlEvent::EVENT_NAME, function(ReturnUrlEvent $event) use($url, &$eventFired){
            $eventFired[] = ReturnUrlEvent::EVENT_NAME;
            $event->setUrl($url);
            $event->stopPropagation();
        }, 99999);

        //act
        $this->client->request(
            'POST',
            $this->generateUrl('payment_digiflow_user_return'),
            $params
        );
        $response = $this->client->getResponse();

        //assert
        $this->assertTrue($response->isRedirect($url));
        $this->assertEquals(array(GetProcesserEvent::EVENT_NAME, QuertPaymentResultEvent::EVENT_NAME, ReturnUrlEvent::EVENT_NAME), $eventFired);
    }

    public function test_serverNotifyAction_ext_data_驗證錯誤()
    {
        //arrange
        $url = 'http://foo.bar/';
        $extData = 'ext_data';
        $ordernumber = 'A12345';
        $eventFired = array();
        $params = array(
            'order_no' => $ordernumber,
            'ext_data' => $extData,
        );
        $result = array(
            'return_code' => '000000',
            'return_msg' => 'ok',
        );

        $processer = $this->getMockBuilder(DigiflowCreditProcesser::class)
            ->setMethods(array('verify'))
            ->getMock();

        $processer
            ->expects($this->once())
            ->method('verify')
            ->with($ordernumber, $extData)
            ->willReturn(false);

        $dispatcher = $this->client->getContainer()->get('event_dispatcher');

        $dispatcher->addListener(GetProcesserEvent::EVENT_NAME, function(GetProcesserEvent $event) use($processer, &$eventFired){
            $eventFired[] = GetProcesserEvent::EVENT_NAME;
            $event->setProcesser($processer);
            $event->stopPropagation();
        }, 99999);

        $dispatcher->addListener(QuertPaymentResultEvent::EVENT_NAME, function(QuertPaymentResultEvent $event) use($result, &$eventFired){
            $eventFired[] = QuertPaymentResultEvent::EVENT_NAME;
            $this->assertEquals($result, $event->getQueryPaymentResult());
            $event->stopPropagation();
        }, 99999);

        //act
        $this->client->request(
            'POST',
            $this->generateUrl('payment_digiflow_server_notify'),
            $params
        );
        $response = $this->client->getResponse();

        //assert
        $this->assertTrue($response->isOk());
        $this->assertEquals(array(GetProcesserEvent::EVENT_NAME), $eventFired);
    }

    public function test_serverNotifyAction()
    {
        //arrange
        $url = 'http://foo.bar/';
        $extData = 'ext_data';
        $ordernumber = 'A12345';
        $eventFired = array();
        $params = array(
            'order_no' => $ordernumber,
            'ext_data' => $extData,
        );
        $result = array(
            'return_code' => '000000',
            'return_msg' => 'ok',
        );

        $processer = $this->getMockBuilder(DigiflowCreditProcesser::class)
            ->setMethods(array('verify'))
            ->getMock();

        $processer
            ->expects($this->once())
            ->method('verify')
            ->with($ordernumber, $extData)
            ->willReturn($result);

        $dispatcher = $this->client->getContainer()->get('event_dispatcher');

        $dispatcher->addListener(GetProcesserEvent::EVENT_NAME, function(GetProcesserEvent $event) use($processer, &$eventFired){
            $eventFired[] = GetProcesserEvent::EVENT_NAME;
            $event->setProcesser($processer);
            $event->stopPropagation();
        }, 99999);

        $dispatcher->addListener(QuertPaymentResultEvent::EVENT_NAME, function(QuertPaymentResultEvent $event) use($result, &$eventFired){
            $eventFired[] = QuertPaymentResultEvent::EVENT_NAME;
            $this->assertEquals($result, $event->getQueryPaymentResult());
            $event->stopPropagation();
        }, 99999);

        //act
        $this->client->request(
            'POST',
            $this->generateUrl('payment_digiflow_server_notify'),
            $params
        );
        $response = $this->client->getResponse();

        //assert
        $this->assertTrue($response->isOk());
        $this->assertEquals(array(GetProcesserEvent::EVENT_NAME, QuertPaymentResultEvent::EVENT_NAME), $eventFired);
    }
}