<?php
namespace Widget\Payment\DigiflowBundle\Processer;

use JMS\DiExtraBundle\Annotation as DI;
use Widget\Payment\DigiflowBundle\Event\QuertPaymentResultEvent;
use Widget\PaymentBundle\Event\GetProcesserEvent;
use Widget\PaymentBundle\Event\ProcessPaymentEvent;
use Widget\PaymentBundle\Event\QueryAvailablePaymentEvent;
use Widget\PaymentBundle\Event\ReceiveOrderEvent;
use Widget\PaymentBundle\Event\ReceivePaymentnumberEvent;

/**
 * @DI\Service()
 * @DI\Tag("kernel.event_listener", attributes = {"public": false, "event": ProcessPaymentEvent::EVENT_NAME, "method": "process"})
 * @DI\Tag("kernel.event_listener", attributes = {"public": false, "event": GetProcesserEvent::EVENT_NAME, "method": "getProcesser"})
 */
class DigiflowCvsProcesser extends Base\BaseDigiflowProcesser
{
    const PROCESSER_NAME = 'DigiflowCvs';

    /**
     * @return \DateTime
     */
    protected function getPaymentExpiredAt()
    {
        $current = \DateTime::createFromFormat('U', $this->getCurrentTime());
        return $current->modify("+{$this->config['expire_day']}days -1day");
    }

    protected function getPaymentParams($ordernumber, $amount)
    {
        return array(
            'version' => '1.0',
            'merchant_id' => $this->config['merchant_id'],
            'terminal_id' => $this->config['terminal_id'],
            'order_no' => $ordernumber,
            'currency' => 'TWD',
            'order_amount' => $amount*100,
            'order_desc' => $ordernumber,
            'expiry_time' => $this->getPaymentExpiredAt()->format('Ymd000000'),
            'payment_type' => '170',
            'timestamp' => $this->getCurrentTime()*1000,
            'ext_data' => $this->createExtData($ordernumber),
        );
    }

    /**
     * @DI\Observe(QuertPaymentResultEvent::EVENT_NAME)
     */
    public function onReceivePaymentNumber(QuertPaymentResultEvent $event)
    {
        $result = $event->getQueryPaymentResult();

        if(($result['payment_type']??null) != '170'){ //付款方式必須為超商繳款
            return;
        }

        if(($result['order_status']??null) != 0){ //必須尚未付款
            return;
        }

        $event->stopPropagation();

        $event = new ReceivePaymentnumberEvent($result['order_no']??null, "{$result['bank']}-{$result['account_no']}", $this->getPaymentExpiredAt(), $result);
        $this->emitReceivePaymentnumber($event);
    }

    /**
     * @DI\Observe(QuertPaymentResultEvent::EVENT_NAME)
     */
    public function onReceiveOrder(QuertPaymentResultEvent $event)
    {
        $result = $event->getQueryPaymentResult();

        if(($result['payment_type']??null) != '170'){ //付款方式必須為超商繳款
            return;
        }

        if(($result['order_status']??null) != 1){ //必須已付款
            return;
        }

        $event->stopPropagation();

        $event = new ReceiveOrderEvent($result['order_no']??null, ($result['order_amount']??null)/100, true, static::PROCESSER_NAME, $result);
        $this->emitReceiveOrder($event);
    }


    /**
     * @DI\Observe(QueryAvailablePaymentEvent::EVENT_NAME)
     */
    public function onQueryAvailablePaymentEvent(QueryAvailablePaymentEvent $event)
    {
        if($event->getAmount() > 20000){
            return;
        }

        if($event->getAmount() < 30){
            return;
        }

        $event->addAvailablePayment(static::PROCESSER_NAME);
    }
}
