<?php
namespace Widget\Payment\DigiflowBundle\Processer;

use JMS\DiExtraBundle\Annotation as DI;
use Widget\Payment\DigiflowBundle\Event\QuertPaymentResultEvent;
use Widget\PaymentBundle\Event\GetProcesserEvent;
use Widget\PaymentBundle\Event\ProcessPaymentEvent;
use Widget\PaymentBundle\Event\QueryAvailablePaymentEvent;
use Widget\PaymentBundle\Event\ReceiveOrderEvent;

/**
 * @DI\Service()
 * @DI\Tag("kernel.event_listener", attributes = {"public": false, "event": ProcessPaymentEvent::EVENT_NAME, "method": "process"})
 * @DI\Tag("kernel.event_listener", attributes = {"public": false, "event": GetProcesserEvent::EVENT_NAME, "method": "getProcesser"})
 */
class DigiflowCreditProcesser extends Base\BaseDigiflowProcesser
{
    const PROCESSER_NAME = 'DigiflowCredit';

    protected function getPaymentParams($ordernumber, $amount)
    {
        return array(
            'version' => '1.0',
            'merchant_id' => $this->config['merchant_id'],
            'terminal_id' => $this->config['terminal_id'],
            'order_no' => $ordernumber,
            'currency' => 'TWD',
            'order_amount' => $amount*100,
            'order_desc' => $ordernumber,
            'expiry_time' => strftime('%Y%m%d%H%M%S', $this->getCurrentTime() + 1800),
            'payment_type' => '111',
            'timestamp' => $this->getCurrentTime()*1000,
            'ext_data' => $this->createExtData($ordernumber),
        );
    }

    /**
     * @DI\Observe(QuertPaymentResultEvent::EVENT_NAME)
     */
    public function onQueryPayment(QuertPaymentResultEvent $event)
    {
        $result = $event->getQueryPaymentResult();

        if(($result['payment_type']??null) != '111'){ //付款方式必須為信用卡
            return;
        }

        if(($result['order_status']??null) != 1){ //必須已付款
            return;
        }

        $event->stopPropagation();

        $event = new ReceiveOrderEvent($result['order_no']??null, ($result['order_amount']??null)/100, true, static::PROCESSER_NAME, $result);
        $this->emitReceiveOrder($event);
    }

    /**
     * @DI\Observe(QueryAvailablePaymentEvent::EVENT_NAME)
     */
    public function onQueryAvailablePaymentEvent(QueryAvailablePaymentEvent $event)
    {
        if($event->getAmount() < 10){
            return;
        }

        $event->addAvailablePayment(static::PROCESSER_NAME);
    }

}