<?php
namespace Widget\Payment\DigiflowBundle\Processer\Base;

use JMS\DiExtraBundle\Annotation as DI;
use Widget\Payment\DigiflowBundle\Lib\ShaHash;
use Widget\PaymentBundle\Event\GetProcesserEvent;
use Widget\PaymentBundle\Event\ProcessPaymentEvent;
use Widget\PaymentBundle\Event\ReceiveOrderEvent;
use Widget\PaymentBundle\Event\ReturnUrlEvent;
use Widget\PaymentBundle\Processer\ProcesserBase;

abstract class BaseDigiflowProcesser extends ProcesserBase
{
    /** @var ShaHash */
    protected $shaHash;

    abstract protected function getPaymentParams($ordernumber, $amount);

    /**
     * @DI\InjectParams({
     *    "config" = @DI\Inject("widget_payment.config"),
     * })
     */
    public function injectConfig($config)
    {
        $this->config = (isset($config[static::PROCESSER_NAME])?$config[static::PROCESSER_NAME]:array());
        $this->prepareHasher();
    }

    protected function prepareHasher()
    {
        $this->shaHash = new ShaHash($this->config['key']??null);
    }

    protected function createPaymentParams($params)
    {
        $sign = $this->shaHash->createHash($params);
        $params['sign'] = $sign;
        return $params;
    }

    protected function handlePayment($params)
    {
        $result = json_decode($this->doPost("{$this->config['gateway_url']}universal/order", $this->createPaymentParams($params)), true);

        if($result['return_code'] === '000000'){
            return $result['payment_url'];
        }

        $receiveOrderEvent = new ReceiveOrderEvent(
            $params['order_no'],
            $params['order_amount'] / 100,
            false,
            static::PROCESSER_NAME,
            $result
        );

        $this->emitReceiveOrder($receiveOrderEvent);

        $retutrnUrlEvent = new ReturnUrlEvent($params['order_no']);
        $this->emitReturnUrl($retutrnUrlEvent);

        return $retutrnUrlEvent->getUrl();
    }

    protected function createExtData($ordernumber)
    {
        return $this->shaHash->createHash(array('ordernumber' => $ordernumber));
    }

    protected function getCurrentTime()
    {
        return time();
    }

    public function verify($ordernumber, $extData)
    {
        if($this->createExtData($ordernumber) !== $extData) {
            return false;
        }

        $params = $this->createPaymentParams(array(
            'version' => '1.0',
            'merchant_id' => $this->config['merchant_id'],
            'terminal_id' => $this->config['terminal_id'],
            'order_no' => $ordernumber,
            'timestamp' => $this->getCurrentTime()*1000,
        ));

        $result = json_decode($this->doPost("{$this->config['gateway_url']}universal/query", $params), true);

        if($result['return_code'] != '000000'){
            return false;
        }

        return $result;
    }

    public function process(ProcessPaymentEvent $event)
    {
        if(!$this->config || $event->getPaymentType() != static::PROCESSER_NAME){
            return;
        }
        $event->stopPropagation();

        $params = $this->getPaymentParams($event->getOrdernumber(), $event->getAmount());
        $paymentUrl = $this->handlePayment($params);
        $event->getProcesserResult()->setForwardRedirect($paymentUrl);
    }

    public function getProcesser(GetProcesserEvent $event)
    {
        if($event->getPaymentType() != static::PROCESSER_NAME){
            return;
        }

        $event->stopPropagation();
        $event->setProcesser($this);
    }
}
