<?php
namespace Widget\Payment\DigiflowBundle\Controller\Front;

use JMS\DiExtraBundle\Annotation as DI;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Widget\Payment\DigiflowBundle\Event\QuertPaymentResultEvent;
use Widget\Payment\DigiflowBundle\Processer\Base\BaseDigiflowProcesser;
use Widget\PaymentBundle\Event\ReturnUrlEvent;

/**
 * 數位鎏金流處理
 */
class DigiflowController extends Controller
{
    /**
     * @var EventDispatcherInterface
     * @DI\Inject()
     */
    protected $eventDispatcher;

    /**
     * 交易完成返回
     * @Route("/return", name="payment_digiflow_user_return")
     */
    public function userReturnAction(Request $request)
    {
        $ordernumber = $request->request->get('order_no');
        $extData = $request->request->get('ext_data');
        $this->processQueryOrder($ordernumber, $extData);
        return $this->handleReturnUrl($ordernumber);
    }

    /**
     * 付款完成通知
     * @Route("/notify", name="payment_digiflow_server_notify")
     */
    public function serverNotifyAction(Request $request)
    {
        $ordernumber = $request->request->get('order_no');
        $extData = $request->request->get('ext_data');
        $this->processQueryOrder($ordernumber, $extData);
        return new Response();
    }

    protected function handleReturnUrl($ordernumber)
    {
        $event = new ReturnUrlEvent($ordernumber);
        $this->eventDispatcher->dispatch(ReturnUrlEvent::EVENT_NAME, $event);
        $url = $event->getUrl();

        if($url == null){
            throw $this->createNotFoundException();
        }

        return $this->redirect($url);
    }

    protected function processQueryOrder($ordernumber, $extData)
    {
        /** @var BaseDigiflowProcesser $processer */
        $processer = $this->get('widget_payment.payment')->getProcesser('DigiflowCredit');
        $result = $processer->verify($ordernumber, $extData);

        if($result !== false){
            $this->processOrderResult($result);
        }
    }

    protected function processOrderResult($result)
    {
        $event = new QuertPaymentResultEvent($result);
        $this->eventDispatcher->dispatch(QuertPaymentResultEvent::EVENT_NAME, $event);
    }

}