<?php
namespace Widget\Payment\CathayBundle\Tests\Processer\Cathay;

use Backend\BaseBundle\Tests\Fixture\BaseTestCase;
use Widget\PaymentBundle\Event\ProcessPaymentEvent;
use Widget\PaymentBundle\Event\QueryAvailablePaymentEvent;
use Widget\Payment\CathayBundle\Processer\Cathay\CathayProcesser;

class CathayProcesserTest extends BaseTestCase
{
    public function test_processCredit_bad_paymentType()
    {
        //arrange
        $ordernumber = 'o12345';
        $amount = 123;
        $paymentInfo = array('a', 'b', 'c');
        $processer = $this->getMockBuilder(CathayProcesser::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $config = array(
            'CathayCredit' => array(
                'store_id' => 'test_store_id',
            ),
        );
        $this->setObjectAttribute($processer, 'config', $config);
        $event = new ProcessPaymentEvent('BadCredit', $ordernumber, $amount, $paymentInfo);

        //act
        $processer->processCredit($event);
        $result = $event->getProcesserResult();

        //assert
        $this->assertFalse($result->isProcessed());
    }

    public function test_processCredit_bad_config()
    {
        //arrange
        $ordernumber = 'o12345';
        $amount = 123;
        $paymentInfo = array('a', 'b', 'c');
        $processer = $this->getMockBuilder(CathayProcesser::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $config = array(
            'BadCredit' => array(
                'store_id' => 'test_store_id',
            ),
        );
        $this->setObjectAttribute($processer, 'config', $config);
        $event = new ProcessPaymentEvent('CathayCredit', $ordernumber, $amount, $paymentInfo);

        //act
        $processer->processCredit($event);
        $result = $event->getProcesserResult();

        //assert
        $this->assertFalse($result->isProcessed());
    }

    public function test_processCredit_valid()
    {
        //arrange
        $ordernumber = 'o12345';
        $amount = 123;
        $paymentInfo = array('a', 'b', 'c');
        $processer = $this->getMockBuilder(CathayProcesser::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $config = array(
            'CathayCredit' => array(
                'store_id' => 'test_store_id',
                'gateway_url' =>  'https://sslpayment.uwccb.com.tw/Order_Initial.asp',
            ),
        );
        $this->setObjectAttribute($processer, 'config', $config);
        $event = new ProcessPaymentEvent('CathayCredit', $ordernumber, $amount, $paymentInfo);

        //act
        $processer->processCredit($event);
        $result = $event->getProcesserResult();

        //assert
        $this->assertTrue($result->isProcessed());
        $this->assertFalse($this->getObjectAttribute($result, 'isRedirect'));
        $this->assertEquals(array(
            'ordernumber' => $ordernumber,
            'amount' => $amount,
            'storeid' => $config['CathayCredit']['store_id'],
        ), $this->getObjectAttribute($result, 'params'));
    }

    public function test_onQueryAvailablePaymentEvent_ok()
    {
        // arrange
        $amount = 100;
        $processer = $this->getMockBuilder(CathayProcesser::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $event = $this->getMockBuilder(QueryAvailablePaymentEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $this->setObjectAttribute($event, 'amount', $amount);

        // act
        $processer->onQueryAvailablePaymentEvent($event);
        $result = $event->getAvailablePayment();

        // asset
        $this->assertEquals(array('CathayCredit'), $result);
    }

    public function test_onQueryAvailablePaymentEvent_bad()
    {
        // arrange
        $amount = 5;
        $processer = $this->getMockBuilder(CathayProcesser::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $event = $this->getMockBuilder(QueryAvailablePaymentEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $this->setObjectAttribute($event, 'amount', $amount);

        // act
        $processer->onQueryAvailablePaymentEvent($event);
        $result = $event->getAvailablePayment();

        // asset
        $this->assertEquals(array(), $result);
    }
}
