<?php
namespace Widget\Payment\CathayBundle\Processer\Cathay;

use JMS\DiExtraBundle\Annotation as DI;
use Widget\PaymentBundle\Event\GetProcesserEvent;
use Widget\PaymentBundle\Event\ProcessPaymentEvent;
use Widget\PaymentBundle\Event\QueryAvailablePaymentEvent;
use Widget\PaymentBundle\Event\VerifyOrderEvent;
use Widget\PaymentBundle\Processer\ProcesserBase;

/**
 * 國泰世華付款金流模組
 * @DI\Service("widget_payment.processer.cathay")
 */
class CathayProcesser extends ProcesserBase
{
    const CREDIT_EXPIRE = 1800;
    const UNION_EXPIRE = 1800;
    //const CREDIT_GATEWAY_URL = 'https://sslpayment.uwccb.com.tw/Order_Initial.asp';
    const UNIONPAY_GATEWAY_URL = 'https://sslpayment.uwccb.com.tw/EPOSService/UPOPPayment/OrderInitial.aspx';

    protected $handledPaymentType = array('CathayCredit');

    /**
     * @DI\InjectParams({
     *    "config" = @DI\Inject("widget_payment.config"),
     * })
     */
    public function injectConfig($config)
    {
        $this->config = $config;
    }

    /**
     * 信用卡
     * @DI\Observe(ProcessPaymentEvent::EVENT_NAME)
     */
    public function processCredit(ProcessPaymentEvent $event)
    {
        if(!isset($this->config['CathayCredit']) || $event->getPaymentType() != 'CathayCredit'){
            return;
        }
        $event->getProcesserResult()->setForwardPost($this->config['CathayCredit']['gateway_url'], array(
            'storeid' => $this->config['CathayCredit']['store_id'],
            'ordernumber' => $event->getOrdernumber(),
            'amount' => $event->getAmount(),
        ));
        $event->stopPropagation();
    }

    /**
     * @DI\Observe(GetProcesserEvent::EVENT_NAME)
     */
    public function getProcesser(GetProcesserEvent $event)
    {
        if(!in_array($event->getPaymentType(), $this->handledPaymentType)){
            return;
        }

        $event->stopPropagation();
        $event->setProcesser($this);
    }

    /**
     * @DI\Observe(QueryAvailablePaymentEvent::EVENT_NAME)
     */
    public function onQueryAvailablePaymentEvent(QueryAvailablePaymentEvent $event)
    {
        if($event->getAmount() <= 10){
            return;
        }
        $event->addAvailablePayment('CathayCredit');
    }

}