<?php
namespace Widget\Payment\CathayBundle\Controller\Front;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\HttpFoundation\Request;
use Widget\PaymentBundle\Event\ReceiveOrderEvent;
use Widget\PaymentBundle\Event\ReturnUrlEvent;
use Widget\PaymentBundle\Event\VerifyAmountEvent;

/**
 * 國泰世華金流處理
 * @Route("/")
 */
class CathayController extends Controller
{
    /**
     * 信用卡刷卡金額確認 Callback
     * @Route("/c/c", name="payment_cathay_credit_confirm")
     * @Template()
     */
    public function creditConfirmAction(Request $request)
    {
        $storeId = $request->get('storeid', null);
        $config = $this->get('widget_payment.config');

        if(!$config || !isset($config['CathayCredit']) || $config['CathayCredit']['store_id'] != $storeId){
            throw $this->createNotFoundException();
        }

        $processer = $this->get('widget_payment.payment')->getProcesser('CathayCredit');
        $event = new VerifyAmountEvent($request->get('ordernumber'), $request->get('amount'));
        $processer->emitVerifyOrder($event);
        return array('valid' => $event->isValid());
    }

    /**
     * 信用卡 接收訂單授權結果 callback
     * @Route("/c/r", name="payment_cathay_credit_receive")
     * @Template()
     */
    public function creditReceiveOrderAction(Request $request)
    {
        $storeId = $request->get('storeid', null);
        $config = $this->get('widget_payment.config');

        if(!$config || !isset($config['CathayCredit']) || $config['CathayCredit']['store_id'] != $storeId){
            throw $this->createNotFoundException();
        }

        $ordernumber = $request->get('ordernumber');
        $amount = $request->get('amount');
        $responsecode = $request->get('JPOSresponsecode');
        $originInfo = array(
            'storeid' => $storeId,
            'ordernumber' => $ordernumber,
            'amount' => $amount,
            'JPOSauthamount' => $request->get('JPOSauthamount'),
            'JPOSresponsecode' => $responsecode,
            'JPOSauthstatus' => $request->get('JPOSauthstatus'),
            'JPOSapprovecode' => $request->get('JPOSapprovecode'),
            'JPOStransdate' => $request->get('JPOStransdate'),
            'JPOStranstime' => $request->get('JPOStranstime'),
        );

        $processer = $this->get('widget_payment.payment')->getProcesser('CathayCredit');
        $event = new ReceiveOrderEvent($ordernumber, $amount, $responsecode === '00', 'CathayCredit', $originInfo);
        $processer->emitReceiveOrder($event);
        $returnUrlEvent = new ReturnUrlEvent($ordernumber);
        $processer->emitReturnUrl($returnUrlEvent);
        return array('url' => $returnUrlEvent->getUrl());
    }
}