<?php
namespace Widget\OrderBundle\Tests\Service;

use Widget\OrderBundle\Service\PaymentToken;

class PaymentTokenTest extends \PHPUnit_Framework_TestCase
{
    protected function setObjectAttribute($object, $attributeName, $value)
    {
        $reflect = new \ReflectionClass($object);
        $property = $reflect->getProperty($attributeName);
        $property->setAccessible(true);
        $property->setValue($object, $value);
    }

    public function test_injectSecret()
    {
        // arrange
        $secret = "test secret";
        $paymentToken = $this->getMockBuilder(PaymentToken::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();

        // act
        $paymentToken->injectSecret($secret);

        // assert
        $this->assertEquals($secret , $this->getObjectAttribute($paymentToken,'secret'));

    }

    public function test_createToken()
    {
        // arrange
        $token = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJwYXltZW50Ijp7Im9yZGVybnVtYmVyIjoidGVzdF9vcmRlcl8xMjMiLCJhbW91bnQiOjUwMCwiaW5mbyI6InRlc3QgcGF5bWVudCBpbmZvIn0sImlhdCI6MTQ4MzExMzYwMCwibmJmIjoxNDgzMTEzNjAwLCJleHAiOjE1MTQ2NDk2MDB9.xw_HNQZlMW9ovbnGOR3Vdxv5qIcSCnCqFdJkCGxyEQQ";
        $secret = "secret";
        $ordernumber = "test_order_123";
        $amount = 500;
        $paymentInfo = "test payment info";
        $expiredAt = new \DateTime("2017-12-31");
        $paymentToken = $this->getMockBuilder(PaymentToken::class)
            ->disableOriginalConstructor()
            ->setMethods(array('getTime'))
            ->getMock();
        $this->setObjectAttribute($paymentToken,'secret',$secret);
        $paymentToken
            ->expects($this->once())
            ->method('getTime')
            ->willReturnCallback(function(){
                // token 內設定的時間
                return 1483113600;
            });

        // act
        $result = $paymentToken->createToken($ordernumber, $amount, $paymentInfo,  $expiredAt);
        // assert
        $this->assertEquals($token, (string)$result);

    }

    public function test_verifyToken_bad_secret()
    {
        // arrange
        $jwtToken = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJwYXltZW50Ijp7Im9yZGVybnVtYmVyIjoidGVzdF9vcmRlcl8xMjMiLCJhbW91bnQiOjUwMCwiaW5mbyI6InRlc3QgcGF5bWVudCBpbmZvIn0sInNsdWciOiJkZ2ZhY3RvciIsImlhdCI6MTQ4MzExMzYwMCwibmJmIjoxNDgzMTEzNjAwLCJleHAiOjE1MTQ2NDk2MDB9.ATwzEzkmOitZ6w10nwmvMgxfj7kEV4svb_G82DHYcZA";
        $fakeSecret = "asedfasdfa";
        $paymentToken = $this->getMockBuilder(PaymentToken::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $this->setObjectAttribute($paymentToken,'secret',$fakeSecret);
        
        // act
        $result = $paymentToken->verifyToken($jwtToken);

        // assert
        $this->assertFalse($result);
    }

    public function test_verifyToken_bad_expired()
    {
        // arrange
        // nbf 2005-02-25
        // exp 2007-06-29
        $jwtToken = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJwYXltZW50Ijp7Im9yZGVybnVtYmVyIjoidGVzdF9vcmRlcl8xMjMiLCJhbW91bnQiOjUwMCwiaW5mbyI6InRlc3QgcGF5bWVudCBpbmZvIn0sInNsdWciOiJkZ2ZhY3RvciIsImlhdCI6MTE4MjExMzYwMCwibmJmIjoxMTgzMTEzNjAwLCJleHAiOjEwMTQ2NDk2MDB9.7JOI7cKc_vBzTFIyQNV2orNN7Jy1FI2ae9Fc5Evgquw";
        $secret = "secret";
        $paymentToken = $this->getMockBuilder(PaymentToken::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $this->setObjectAttribute($paymentToken,'secret',$secret);

        // act
        $result = $paymentToken->verifyToken($jwtToken);

        // assert
        $this->assertFalse($result);
    }

    public function test_verifyToken_ok()
    {
        // arrange
        // nbf 2013-10-30
        // exp 2021-03-02        
        $payment = (object)array(
            'ordernumber' => "test_order_123",
            'amount'      => 500,
            'info'        => "test payment info"
        );
        $jwtToken = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJwYXltZW50Ijp7Im9yZGVybnVtYmVyIjoidGVzdF9vcmRlcl8xMjMiLCJhbW91bnQiOjUwMCwiaW5mbyI6InRlc3QgcGF5bWVudCBpbmZvIn0sInNsdWciOiJkZ2ZhY3RvciIsImlhdCI6MTM4MzExMzYwMCwibmJmIjoxMzgzMTEzNjAwLCJleHAiOjE2MTQ2NDk2MDB9.xrm326zbnvfXQpVGj1knkl-gw_HZXzTYOplCozr8Z3Y";
        $secret = "secret";
        $paymentToken = $this->getMockBuilder(PaymentToken::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $this->setObjectAttribute($paymentToken,'secret',$secret);

        // act
        $result = $paymentToken->verifyToken($jwtToken);

        // assert
        $this->assertEquals($payment,$result);
    }
}