<?php
namespace Widget\OrderBundle\Tests\EventListener;

use Backend\BaseBundle\Service\CustomMailerService;
use Backend\BaseBundle\Service\SendMailService;
use Backend\BaseBundle\Tests\Fixture\BaseKernelTestCase;
use Widget\MemberBundle\Model\MemberQuery;
use Widget\OrderBundle\Model\OrderInfo;
use Widget\OrderBundle\Model\OrderInfoQuery;
use Widget\OrderBundle\Model\OrderQuery;
use Widget\PaymentBundle\Event\ReceiveOrderEvent;

class OrderSendMailListenerTest extends BaseKernelTestCase
{
    /**
     * 1.測試status錯誤時是否會直接 return
     */
    public function test_onReceiveOrderStatusEvent_status_false()
    {
        //arrange
        $listener = $this->container->get('widget.order_bundle.event_listener.order_send_mail_listener');
        $orderId = 'P0002';
        $paymentType = 'TestPayment';
        $amountForPay = 150;
        $status = false;
        $paymentInfo = '800-6521782765376';
        $event = new ReceiveOrderEvent($orderId, $amountForPay, $status, $paymentType, $paymentInfo);

        //act
        $listener->onReceiveOrderStatusEvent($event);

        //assert
        $this->assertTrue($event->isPropagationStopped());
    }

    /**
     * 1.測試資料正確時是否會發信
     */
    public function test_onReceiveOrderStatusEvent_valid_data_and_sand_mail()
    {
        //arrange
        $listener = $this->container->get('widget.order_bundle.event_listener.order_send_mail_listener');
        $orderId = 'P0000';
        $paymentType = 'TestPayment';
        $amountForPay = 150;
        $status = true;
        $paymentInfo = '800-6521782765376';

        $mailerService = $this->getMockBuilder(SendMailService::class)
            ->setMethods(array('send'))
            ->getMock();
        $mailerService
            ->expects($this->once())
            ->method('send')
            ;

        $this->setObjectAttribute($listener, 'sendMailService', $mailerService);

        $event = new ReceiveOrderEvent($orderId, $amountForPay, $status, $paymentType, $paymentInfo);

        //act
        $listener->onReceiveOrderStatusEvent($event);

        //assert
        $this->assertFalse($event->isPropagationStopped());
    }

    /**
     * 1.測試繳款發信
     */
    public function test_onReceivePaymentnumberEvent_valid_data_and_sand_mail()
    {
        //arrange
        $listener = $this->container->get(
            'widget.order_bundle.event_listener.order_send_mail_listener'
        );
        $orderId = 'P0000';
        $paymentType = 'TestPayment';
        $amountForPay = 150;
        $status = true;
        $paymentInfo = '800-6521782765376';

        $mailerService = $this->getMockBuilder(SendMailService::class)
            ->setMethods(array('send'))
            ->getMock();
        $mailerService
            ->expects($this->once())
            ->method('send')
        ;

        $this->setObjectAttribute($listener, 'sendMailService', $mailerService);

        $event = new ReceiveOrderEvent($orderId, $amountForPay, $status, $paymentType, $paymentInfo);

        //act
        $listener->onReceiveOrderStatusEvent($event);

        //assert
        $this->assertFalse($event->isPropagationStopped());
    }
}