<?php

namespace Widget\OrderBundle\Tests\Controller\BackendAPI;

use Backend\BaseBundle\Model\SiteUserQuery;
use Backend\BaseBundle\Propel\I18n;
use Backend\BaseBundle\Tests\Fixture\BackendWebTestCase;
use Widget\OrderBundle\Model\OrderStatus;
use Widget\OrderBundle\Model\OrderStatusI18nQuery;
use Widget\OrderBundle\Model\OrderStatusQuery;

class OrderStatusController extends BackendWebTestCase
{
    public function test_createAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);

        $params = array(
            'name' => '新的訂單狀態',
            'status' => false,
            'default_status' => true,
        );

        //act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_order_backendapi_orderstatus_create'),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();
        $result = json_decode($response->getContent(), true);

        //assert
        $orderStatus = OrderStatusQuery::create()->findOneById($result['id']);

        $this->assertTrue($response->isOk());
        $this->assertEquals($params['name'], $orderStatus->getName());
        $this->assertEquals($params['status'], $orderStatus->getStatus());
        $this->assertEquals($params['default_status'], $orderStatus->getDefaultStatus());

        $orderStatus->delete();
    }

    public function test_searchAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);

        $searchParams = array(
            'page' => 1,
            'sort' => array(
                'name' => 'asc'
            ),
            'search' => array(
                'name' => '%款%',
            ),
        );

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_order_backendapi_orderstatus_search', $searchParams),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );

        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        // assert
        $this->assertTrue($response->isOk());
        $this->assertArrayHasKey('pager', $responseArray);
        $this->assertArrayHasKey('page', $responseArray['pager']);
        $this->assertArrayHasKey('pages', $responseArray['pager']);
        $this->assertArrayHasKey('rows', $responseArray['pager']);

        $this->assertArrayHasKey('data', $responseArray);
        $this->assertArrayHasKey('name', $responseArray['data'][0]);
        $this->assertArrayHasKey('status', $responseArray['data'][0]);
        $this->assertArrayHasKey('created_at', $responseArray['data'][0]);
        $this->assertArrayHasKey('updated_at', $responseArray['data'][0]);
    }

    public function test_readAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);

        $orderStatusName = "處理中";
        $query = OrderStatusQuery::create();
        if ($query instanceof I18n) {
            $orderStatus = OrderStatusI18nQuery::create()
                ->findOneByName($orderStatusName);
        }else{
            $orderStatus = $query->findOneByName($orderStatusName);
        }

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_order_backendapi_orderstatus_read', array('id' => $orderStatus->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        //assert
        $this->assertTrue($response->isOk());
        $this->assertEquals($orderStatusName, $responseArray['name']);
    }

    public function test_updateAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);

        $orderStatusName = "處理中";
        $query = OrderStatusQuery::create();
        if ($query instanceof I18n) {
            $orderStatus = OrderStatusI18nQuery::create()
                ->findOneByName($orderStatusName);
        }else{
            $orderStatus = $query->findOneByName($orderStatusName);
        }
        $params = array(
            'name' => '您的貨物已炸燬'
        );

        //act
        $this->client->request(
            'PUT',
            $this->generateUrl('widget_order_backendapi_orderstatus_update', array('id' => $orderStatus->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();
        $result = json_decode($response->getContent(), true);

        // assert
        $orderStatusQuery = OrderStatusQuery::create()->findOneById($result['id']);
        $this->assertTrue($response->isOk());
        $this->assertEquals($params['name'], $orderStatusQuery->getName());

        // reset
        $orderStatusQuery->setName($orderStatusName);
        $orderStatusQuery->save();
    }

    public function test_deleteAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);

        $orderStatusName = "Test123";
        $orderStatus = new OrderStatus();
        $orderStatus->setName($orderStatusName);
        $orderStatus->save();

        //act
        $this->client->request(
            'DELETE',
            $this->generateUrl('widget_order_backendapi_orderstatus_delete', array('id' => $orderStatus->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();
        $result = json_decode($response->getContent(), true);

        //assert
        $query = OrderStatusQuery::create();
        if ($query instanceof I18n){
            $orderStatusQuery = OrderStatusI18nQuery::create()->findOneByName($orderStatusName);
        }else {
            $orderStatusQuery = $query->findOneByName($orderStatusName);
        }
        $this->assertTrue($response->isOk());
        $this->assertNull($orderStatusQuery);
    }

    public function test_allAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_order_backendapi_orderstatus_list'),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        //assert
        $this->assertTrue($response->isOk());

        $this->assertArrayHasKey('name', $responseArray[0]);
        $this->assertArrayHasKey('status', $responseArray[0]);
        $this->assertArrayHasKey('created_at', $responseArray[0]);
        $this->assertArrayHasKey('updated_at', $responseArray[0]);

    }
}