<?php

namespace Widget\OrderBundle\Service;

use Lcobucci\JWT\Builder;
use Lcobucci\JWT\Parser;
use Lcobucci\JWT\Signer\Hmac\Sha256;
use JMS\DiExtraBundle\Annotation as DI;
use Lcobucci\JWT\ValidationData;
use Symfony\Component\HttpFoundation\RequestStack;

/**
 * @DI\Service("widget_order.payment.token")
 */
class PaymentToken
{
    protected $secret;

    /**
     * @DI\InjectParams({
     *     "secret" = @DI\Inject("%secret%")
     * })
     */
    public function injectSecret($secret)
    {
        $this->secret = $secret;
    }
    
    public function getTime()
    {
        return time();
    }


    public function createToken($ordernumber, $amount, $paymentInfo, \DateTime $expiredAt)
    {
        $payment = array(
            'ordernumber' => $ordernumber,
            'amount'      => $amount,
            'info'        => $paymentInfo
        );

        $signer = new Sha256();
        $builder = new Builder();
        $now = $this->getTime();
        $builder
            ->set('payment' , $payment)
            ->setIssuedAt($now)
            ->setNotBefore($now)
            ->setExpiration($expiredAt->format('U'))
        ;

        $token = $builder
            ->sign($signer, $this->secret)
            ->getToken();

        $token->getHeaders();
        $token->getClaims();
        
        return $token;
    }

    public function verifyToken($jwtToken)
    {
        try {
            $token = (new Parser())->parse((string)$jwtToken);

            // 檢查 secret
            if (!$token->verify(new Sha256(), $this->secret)) {
                return false;
            }

            // 檢查 token
            $data = new ValidationData();
            if (!$token->validate($data)) {
                return false;
            }

            // 傳回payload
            $payload = $token->getClaim('payment');
            return $payload;
        }
        catch (\Exception $e){
            return false;
        }
    }
}