<?php

namespace Widget\OrderBundle\EventListener;

use JMS\DiExtraBundle\Annotation as DI;
use Widget\OrderBundle\Event\OrderInvaildEvent;
use Widget\OrderBundle\Event\ReceiveOrderQueryStatusEvent;
use Widget\OrderBundle\Model\OrderStatusQuery;
use Widget\PaymentBundle\Event\PaymentExpiredEvent;

/**
 * @DI\Service()
 */
class OrderRecoverListener
{
    /**
     * @DI\Observe(ReceiveOrderQueryStatusEvent::EVENT_NAME)
     * 這邊負責會下query查詢有效的訂單
     */
    public function onReceiveOrderQueryStatusEvent(ReceiveOrderQueryStatusEvent $event)
    {
        $event->getQuery()
            ->useOrderStatusQuery()
                ->filterByStatus(true)
            ->endUse()
            ->find();

    }

    /**
     * @DI\Observe("event.payment.expired", priority = 1024))
     * 作廢訂單
     */
    public function onReceiveInvalidOrderEvent(PaymentExpiredEvent $event)
    {
        $con = $event->getCon();
        $order = $event->getOrder();
        if(!($orderStatus = OrderStatusQuery::create()
            ->filterByStatus(false)
            ->findOne($con))){
            return;
        }
        $order->setOrderStatus($orderStatus);
        $order->save($con);
    }
}
