<?php
/**
 * Created by PhpStorm.
 * User: bubble
 * Date: 2016/8/3
 * Time: 下午 12:29
 */

namespace Widget\OrderBundle\Event;

use Symfony\Component\EventDispatcher\Event;
use Widget\OrderBundle\Model\Order;

class ReceiveCreateOrderEvent extends Event
{
    const EVENT_NAME = 'event.receive.create.order';

    /** @var Order  */
    protected $order;

    /** @var \PropelPDO  */
    protected $connection;

    public function __construct(Order $order, \PropelPDO $con = null)
    {
        $this->order = $order;
        $this->connection = $con;
    }

    /**
     * @return Order
     */
    public function getOrder()
    {
        return $this->order;
    }

    /**
     * @return \PropelPDO
     */
    public function getConnection()
    {
        return $this->connection;
    }


}