<?php
namespace Widget\OrderBundle\Event;


use Symfony\Component\EventDispatcher\Event;
use Widget\OrderBundle\Service\DiscountBuilder;

class DiscountChainEvent extends Event
{
    const EVENT_NAME = 'event.discount.chains';

    /** @var DiscountBuilder  */
    protected $discountBuilder;

    public function __construct(DiscountBuilder $discountBuilder)
    {
        $this->discountBuilder = $discountBuilder;
    }

    /**
     * @return DiscountBuilder
     */
    public function getDiscountBuilder()
    {
        return $this->discountBuilder;
    }

}