<?php

namespace Widget\OrderBundle\Controller\BackendAPI;

use Backend\BaseBundle\Controller\BackendAPI\BaseBackendAPIController;
use Backend\BaseBundle\Form\Type\APIFormTypeItem;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints\NotBlank;
use Widget\OrderBundle\Model\OrderInfo;

/**
 * @Route("/orderinfo")
 * @Security("has_role_or_superadmin('ROLE_ORDER')")
 */
class OrderInfoController extends BaseBackendAPIController
{
    /**
     * 欄位表單設定
     * 主要是USER送過來的欄位
     * @return APIFormTypeItem[]
     */
    protected function getFormConfig()
    {
        return array(
            (new APIFormTypeItem("buyer_name"))->setOptions(array(
                'required' => true,
                'constraints' => array(
                    new NotBlank(array(
                        'message' => 'error.order.buyer_name.missing_field',
                    )),
                )                
            )),
            (new APIFormTypeItem("buyer_email"))->setOptions(array(
                'required' => true,
                'constraints' => array(
                    new NotBlank(array(
                        'message' => 'error.order.buyer_email.missing_field',
                    )),
                )                
            )),
            (new APIFormTypeItem("buyer_phone"))->setOptions(array(
                'required' => true,
                'constraints' => array(
                    new NotBlank(array(
                        'message' => 'error.order.buyer_phone.missing_field',
                    )),
                )                
            )),
            (new APIFormTypeItem("buyer_zip"))->setOptions(array(
                'required' => true,
                'constraints' => array(
                    new NotBlank(array(
                        'message' => 'error.order.buyer_zip.missing_field',
                    )),
                )                
            )),
            (new APIFormTypeItem("buyer_address"))->setOptions(array(
                'required' => true,
                'constraints' => array(
                    new NotBlank(array(
                        'message' => 'error.order.buyer_address.missing_field',
                    )),
                )                
            )),
            (new APIFormTypeItem("receiver_name"))->setOptions(array(
                'required' => true,
                'constraints' => array(
                    new NotBlank(array(
                        'message' => 'error.order.receiver_name.missing_field',
                    )),
                )                
            )),
            (new APIFormTypeItem("receiver_email"))->setOptions(array(
                'required' => true,
                'constraints' => array(
                    new NotBlank(array(
                        'message' => 'error.order.receiver_email.missing_field',
                    )),
                )                
            )),
            (new APIFormTypeItem("receiver_phone"))->setOptions(array(
                'required' => true,
                'constraints' => array(
                    new NotBlank(array(
                        'message' => 'error.order.receiver_phone.missing_field',
                    )),
                )                
            )),
            (new APIFormTypeItem("receiver_zip"))->setOptions(array(
                'required' => true,
                'constraints' => array(
                    new NotBlank(array(
                        'message' => 'error.order.receiver_zip.missing_field',
                    )),
                )                
            )),
            (new APIFormTypeItem("receiver_address"))->setOptions(array(
                'required' => true,
                'constraints' => array(
                    new NotBlank(array(
                        'message' => 'error.order.price.missing_field',
                    )),
                )                
            )),
        );
    }

    /**
     * 更新
     * @Route("/{id}")
     * @Method({"PUT"})
     * @Security("has_role_or_superadmin('ROLE_ORDER_WRITE')")
     */
    public function updateAction(Request $request, OrderInfo $orderInfo)
    {
        return $this->doProcessForm($orderInfo, $request->getContent());
    }

}