<?php

namespace Widget\OrderBundle\Command;

use Backend\BaseBundle\Model\SiteConfigQuery;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class OrderInitSetupCommand extends ContainerAwareCommand
{

    protected function configure()
    {
        $this
            ->setName('dgfactor:order:setpupinit')
            ->setDescription('建立排程')
            ->setHelp(<<<EOT
The <info>dgfactor:order:setpupinit</info> 建立初始訂單設定:

  <info>php app/console dgfactor:order:setpupinit</info>
EOT
            );
    }

    /**
     * @see Command
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        try {
            $siteConfig = SiteConfigQuery::create()->filterByName('widget_order.mail')->findOneOrCreate();
            $siteConfig->setConfig($this->getDefaultConfig());
            $siteConfig->save();
            $output->writeln("widget_order.mail 已成功初始化");
        }
        catch (\Exception $e) {
            $output->writeln(sprintf('發生錯誤 <comment>%s</comment>', $e->getMessage()));
        }

    }

    protected function getDefaultConfig()
    {

        return array (
            'Payment' =>
                array (
                    'payment_mail_subject' => '訂單編號 {{ordernumber}}  -  和生御品付款通知信件',
                    'payment_mail' => '<center>
  <table cellspacing="0" cellpadding="0" border="1" width="800">
    <tbody><tr>
      <td>
        <table cellspacing="0" cellpadding="0" width="100%">
          <tbody><tr>
            <td style="padding: 20px; background-color: rgb(238, 238, 238);" align="center"><span style="font-size: 19px;"><b>
              《</b></span><b><font color="#222222" face="arial, sans-serif"><span style="font-size: 19px; line-height: normal;">訂單編號 </span></font><span style="font-size: 19px; color: rgb(34, 34, 34); font-family: arial,sans-serif; line-height: normal;">{{ordernumber}}</span><font color="#222222" face="arial, sans-serif"><span style="font-size: 19px; line-height: normal;"> -&nbsp;和</span></font><span style="font-size: 19px; color: rgb(34, 34, 34); font-family: arial,sans-serif; line-height: normal;">生御品</span></b><b style="line-height: 1.42857;"><span style="font-size: 19px; color: rgb(34, 34, 34); font-family: arial,sans-serif; line-height: normal;">付款通知信件</span><span style="font-size: 19px;">》</span></b><b><span style="font-size: 19px; color: rgb(34, 34, 34); font-family: arial,sans-serif; line-height: normal;"><br></span></b></td>
          </tr>
          <tr>
            <td style="padding: 20px; font-size: 15px;"><p>
              </p><p>您好，</p>
              <p>感謝您在和生御品的訂購，請您於繳款期限內完成繳款，</p><p>繳款期限：{{expiredAt|date(\'Y-m-d H:i:s\')}}</p><p>繳款代碼：<span style="color: rgb(44, 45, 48); font-family: Slack-Lato, appleLogo, sans-serif; line-height: 22px; background-color: rgb(249, 249, 249);">{{paymentnumber}}</span></p><p><br></p><p></p><p><span style="color: rgb(34, 34, 34); font-family: arial, sans-serif; line-height: normal;">&lt;請注意：此通知函不代表交易已經完成&gt;</span><br></p>
            <p></p></td>
          </tr>
          <tr>
            <td style="padding: 20px; font-size: 15px; background-color: #EEE;"><br>
              如有任何問題，請與我們連絡，謝謝! &lt;此為系統通知信，請勿直接回覆&gt; 
            </td>
          </tr>
        </tbody></table>
      </td>
    </tr>
  </tbody></table>
</center>',
                ),
            'PaymentSuccess' =>
                array (
                    'payment_success_mail_subject' => '訂單編號 {{ordernumber}}  - 和生御品 付款完成通知信件',
                    'payment_success_mail' => '<center>
  <table cellspacing="0" cellpadding="0" border="1" width="800">
    <tbody><tr>
      <td>
        <table cellspacing="0" cellpadding="0" width="100%">
          <tbody><tr>
            <td style="padding: 20px; background-color: rgb(238, 238, 238);" align="center"><span style="font-size: 19px;"><b>
              《</b></span><font color="#222222" face="arial, sans-serif"><span style="font-size: 19px; line-height: normal;"><b>訂單編號 </b></span></font><span style="font-size: 19px; font-weight: bold; color: rgb(34, 34, 34); font-family: arial, sans-serif; line-height: normal;">{{ordernumber}}&nbsp;</span><font color="#222222" face="arial, sans-serif"><span style="font-size: 19px; line-height: normal;"><b> - &nbsp;</b></span></font><span style="font-size: 19px; font-weight: bold; color: rgb(34, 34, 34); font-family: arial, sans-serif; line-height: normal;">和生御品</span><span style="font-size: 19px; font-weight: bold; color: rgb(34, 34, 34); font-family: arial, sans-serif; line-height: normal;">付款通知信件</span><span style="font-size: 19px; font-weight: bold; line-height: 1.42857;">》</span><span style="font-size: 19px; font-weight: bold; color: rgb(34, 34, 34); font-family: arial, sans-serif; line-height: normal;"><br></span></td>
          </tr>
          <tr>
            <td style="padding: 20px;"><p style="font-size: 15px;">
              </p><p style="font-size: 15px;">您好，</p>
              <p style=""><span style="font-size: 15px; color: rgb(34, 34, 34); font-family: arial, sans-serif; line-height: normal;">我們已經收到您的款項，</span><wbr style="color: rgb(34, 34, 34); font-family: arial, sans-serif; line-height: normal;"><span style="font-size: 15px; color: rgb(34, 34, 34); font-family: arial, sans-serif; line-height: normal;">隨後將會再以email通知您訂單的更新狀態，</span><br style="color: rgb(34, 34, 34); font-family: arial, sans-serif; line-height: normal;"><span style="font-size: 15px; color: rgb(34, 34, 34); font-family: arial, sans-serif; line-height: normal;">或您</span><span style="font-size: 15px; color: rgb(34, 34, 34); font-family: arial, sans-serif; line-height: normal;">可登入</span><span style="background-color: transparent; font-size: 15px; line-height: normal;"><font color="#222222" face="arial, sans-serif">和生御品</font></span><span style="font-size: 15px; color: rgb(34, 34, 34); font-family: arial, sans-serif; line-height: normal; background-color: transparent;">官網，進入 會員專區 &gt;&nbsp;</span><span style="background-color: transparent; font-size: 15px; line-height: normal;"><font color="#222222" face="arial, sans-serif">訂購紀錄</font></span><span style="font-size: 15px; color: rgb(34, 34, 34); font-family: arial, sans-serif; line-height: normal; background-color: transparent;">&nbsp;</span><span style="font-size: 15px; color: rgb(34, 34, 34); font-family: arial, sans-serif; line-height: normal; background-color: transparent;">查詢，再次感謝您的購買。</span></p><p style="font-size: 15px;"><br></p><p style="font-size: 15px;"></p><p style="font-size: 15px;"><br></p>
            <p style="font-size: 15px;"></p></td>
          </tr>
          <tr>
            <td style="padding: 20px; font-size: 15px; background-color: #EEE;"><br>
              如有任何問題，請與我們連絡，謝謝! &lt;此為系統通知信，請勿直接回覆&gt; 
            </td>
          </tr>
        </tbody></table>
      </td>
    </tr>
  </tbody></table>
</center>',
                ),
            'statusChange' =>
                array (
                    'status_change_mail_subject' => '訂單編號 {{ordernumber}} - 和生御品 {{orderStatus}}通知信件',
                    'status_change_mail' => '<center>
  <table cellspacing="0" cellpadding="0" border="1" width="800">
    <tbody><tr>
      <td>
        <table cellspacing="0" cellpadding="0" width="100%">
          <tbody><tr>
            <td style="padding: 20px; background-color: rgb(238, 238, 238);" align="center"><span style="font-size: 19px;"><b>
              《</b></span><font color="#222222" face="arial, sans-serif"><span style="font-size: 19px; line-height: normal;"><b>訂單編號 </b></span></font><span style="font-size: 19px; font-weight: bold; color: rgb(34, 34, 34); font-family: arial, sans-serif; line-height: normal;">{{ordernumber}}&nbsp;</span><font color="#222222" face="arial, sans-serif"><span style="font-size: 19px; line-height: normal;"><b> -&nbsp;和</b></span></font><span style="font-size: 19px; font-weight: bold; color: rgb(34, 34, 34); font-family: arial, sans-serif; line-height: normal;">生御品</span><font color="#222222" face="arial, sans-serif" style="line-height: 18.5714px;"><span style="font-size: 19px; line-height: normal;"><b>&nbsp;</b></span></font><span style="font-size: 19px; font-weight: bold; color: rgb(34, 34, 34); font-family: arial, sans-serif; line-height: normal;">{{orderStatus}}</span><span style="font-size: 19px; font-weight: bold; color: rgb(34, 34, 34); font-family: arial, sans-serif; line-height: normal;">通知信件</span><span style="font-size: 19px; font-weight: bold; line-height: 1.42857;">》</span><span style="font-size: 19px; font-weight: bold; color: rgb(34, 34, 34); font-family: arial, sans-serif; line-height: normal;"><br></span></td>
          </tr>
          <tr>
            <td style="padding: 20px;"><p style="font-size: 15px;">
              </p><p style="font-size: 15px;">您好，</p>
              <p><font color="#222222" face="arial, sans-serif"><span style="font-size: 15px; line-height: normal;">您的訂單狀態為{{orderStatus}}，</span></font></p><p><span style="font-size: 15px; line-height: normal; color: rgb(34, 34, 34); font-family: arial, sans-serif; background-color: transparent;">為了確保您的個人資料安全，本通知信將不顯示訂單明細，</span><br></p><p><span style="font-size: 15px; line-height: normal; color: rgb(34, 34, 34); font-family: arial, sans-serif; background-color: transparent;">建議您可登入</span><span style="background-color: transparent; font-size: 15px; line-height: normal;"><font color="#222222" face="arial, sans-serif">和生御品</font></span><span style="color: rgb(34, 34, 34); font-family: arial, sans-serif; font-size: 15px; line-height: normal; background-color: transparent;">官網，進入 會員專區 &gt;&nbsp;</span><span style="background-color: transparent; font-size: 15px; line-height: normal;"><font color="#222222" face="arial, sans-serif">訂購紀錄</font></span><span style="color: rgb(34, 34, 34); font-family: arial, sans-serif; font-size: 15px; line-height: normal; background-color: transparent;">&nbsp;，</span></p><p><span style="font-size: 15px; line-height: normal; color: rgb(34, 34, 34); font-family: arial, sans-serif; background-color: transparent;">查詢訂單明細與處理進度，謝謝。</span><br></p><p style="font-size: 15px;"></p><p style="font-size: 15px;"><br></p>
            <p style="font-size: 15px;"></p></td>
          </tr>
          <tr>
            <td style="padding: 20px; font-size: 15px; background-color: #EEE;"><br>
              如有任何問題，請與我們連絡，謝謝! &lt;此為系統通知信，請勿直接回覆&gt; 
            </td>
          </tr>
        </tbody></table>
      </td>
    </tr>
  </tbody></table>
</center>',
                ),
        );
        
    }
}