<?php
namespace Widget\OrderBundle\Token;

use Backend\BaseBundle\Token\Service\TokenRequest\TokenRequestInterface;

class OrderTokenRequest implements TokenRequestInterface
{
    const TOKEN_TYPE = 'order';
    const TTL = 3600;

    /** @var OrderInterface  */
    protected $order;

    public function __construct(OrderInterface $order)
    {
        $this->order = $order;
    }

    public function getId()
    {
        return $this->order->getId();
    }

    public function getType()
    {
        return self::TOKEN_TYPE;
    }

    public function getData()
    {
        return array(
            'order' => array(
                'price' => (int) $this->order->getPrice(),
                'currency' => $this->order->getCurrency(),
                'items' => $this->convertOrderItems($this->order->getItems()),
            ),
        );
    }

    public function getTtl()
    {
        return self::TTL;
    }

    /**
     * @param OrderItemInterface[] $orderItems
     */
    protected function convertOrderItems($orderItems)
    {
        $items = array();
        foreach($orderItems as $orderItem){
            $items[] = array(
                'id' => (string)$orderItem->getProductId(),
                'name' => (string)$orderItem->getProductName(),
                'count' => (int)$orderItem->getQuantity(),
                'price' => (int)$orderItem->getUnitPrice(),
                'unit' => (string)$orderItem->getUnit(),
            );
        }
        return $items;
    }
}