<?php
namespace Widget\OrderBundle\Tests\Token;

use Backend\BaseBundle\Tests\Fixture\BaseTestCase;
use Widget\OrderBundle\Model\Order;
use Widget\OrderBundle\Model\OrderItem;
use Widget\OrderBundle\Token\OrderTokenRequest;

class OrderTokenRequestTest extends BaseTestCase
{
    public function test__construct()
    {
        //arrange
        $order = new Order();

        //act
        $tokenRequest = new OrderTokenRequest($order);

        //assert
        $this->assertSame($order, $this->getObjectAttribute($tokenRequest, 'order'));
    }

    public function test_getId()
    {
        //arrange
        $id = '12345';
        $order = new Order();
        $order->setId($id);

        //act
        $tokenRequest = new OrderTokenRequest($order);

        //assert
        $this->assertEquals($id, $tokenRequest->getId());
    }

    public function test_getType()
    {
        //arrange

        //act
        $tokenRequest = new OrderTokenRequest(new Order());

        //assert
        $this->assertEquals('order', $tokenRequest->getType());
    }

    public function test_getData()
    {
        //arrange
        $id = '12345';
        $order = new Order();
        $order->setAmountForPay(1400);
        $orderItem1 = new OrderItem();
        $orderItem1->setProductName('item1')->setProductId(111)->setQuantity(1)->setUnitPrice(100)->setOrder($order);
        $orderItem2 = new OrderItem();
        $orderItem2->setProductName('item2')->setProductId(222)->setQuantity(2)->setUnitPrice(200)->setOrder($order);
        $orderItem3 = new OrderItem();
        $orderItem3->setProductName('item3')->setProductId(333)->setQuantity(3)->setUnitPrice(300)->setOrder($order);
        $tokenRequest = new OrderTokenRequest($order);

        //act
        $result = $tokenRequest->getData();

        //assert
        $this->assertEquals(array(
            'order' => array(
                'price' => 1400,
                'currency' => 'TWD',
                'items' => array(
                    array(
                        'name' => 'item1',
                        'count' => 1,
                        'price' => 100,
                        'id' => '111',
                        'unit' => '個',
                    ),
                    array(
                        'name' => 'item2',
                        'count' => 2,
                        'price' => 200,
                        'id' => '222',
                        'unit' => '個',
                    ),
                    array(
                        'name' => 'item3',
                        'count' => 3,
                        'price' => 300,
                        'id' => '333',
                        'unit' => '個',
                    ),
                ),
            ),
        ), $result);
    }

    public function test_getTtl()
    {
        //arrange
        $order = new Order();
        $tokenRequest = new OrderTokenRequest($order);

        //act
        $result = $tokenRequest->getTtl();

        //assert
        $this->assertEquals(3600, $result);
    }
}