<?php

namespace Widget\OrderBundle\Tests\Service;

use Backend\BaseBundle\SiteConfig\SiteConfigBuilder;
use Backend\BaseBundle\SiteConfig\SiteConfigInterface;
use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Widget\OrderBundle\Service\SetupConfig;
use Widget\OrderBundle\Tests\Fixtures\Service\MockConfigService;

class SetupConfigTest extends BaseWebTestCase
{
    public function setUp()
    {
        parent::setUp();
        $this->prepareConfig();
    }

    private function prepareConfig()
    {
        $container = $this->client->getContainer();
        $config = $this->getMockBuilder(MockConfigService::class)
            ->setMethods()
            ->getMock();
        $container->set('widget_order.config', $config);
    }

    public function test_injectConfig()
    {
        //arrange
        $config = array(1, 2, 3, 4);
        $mockSiteConfig = $this->getMockBuilder(SiteConfigInterface::class)
            ->setMethods(array('__construct', 'set', 'get', 'delete'))
            ->getMock();
        $mockSiteConfig
            ->expects($this->once())
            ->method('get')
            ->willReturnCallback(function($configKey) use($config){
                $this->assertEquals('widget_order', $configKey);
                return $config;
            });
        $siteConfigBuilder = $this->getMockBuilder(SiteConfigBuilder::class)
            ->setMethods(array('build'))
            ->getMock();
        $siteConfigBuilder
            ->expects($this->once())
            ->method('build')
            ->willReturnCallback(function() use($mockSiteConfig){
                return $mockSiteConfig;
            });
        $setupConfig = $this->getMockBuilder(SetupConfig::class)
            ->setMethods(array('exchangeArray'))
            ->getMock();
        $setupConfig
            ->expects($this->once())
            ->method('exchangeArray')
            ->willReturn(function($configForTest) use($config){
                $this->assertEquals($config, $configForTest);
            });
        //act
        $setupConfig->injectConfig($siteConfigBuilder);

        //assert
    }
}