<?php

namespace Widget\OrderBundle\Tests\EventListener;

use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Widget\OrderBundle\Event\ReceiveOrderQueryStatusEvent;
use Widget\OrderBundle\EventListener\OrderRecoverListener;
use Widget\OrderBundle\Model\Order;
use Widget\OrderBundle\Model\OrderPeer;
use Widget\OrderBundle\Model\OrderQuery;
use Widget\OrderBundle\Model\OrderStatus;
use Widget\OrderBundle\Model\OrderStatusQuery;
use Widget\PaymentBundle\Event\PaymentExpiredEvent;

class OrderRecoverListenerTest extends BaseWebTestCase
{
    public function test_onReceiveOrderQueryStatusEvent()
    {
        //arrange
        $orderStatusQuery = $this->getMockBuilder(OrderStatusQuery::class)
            ->disableOriginalConstructor()
            ->setMethods(array('filterByStatus', 'endUse'))
            ->getMock();

        $orderQuery = $this->getMockBuilder(OrderQuery::class)
            ->disableOriginalConstructor()
            ->setMethods(array('useOrderStatusQuery', 'find'))
            ->getMock();
        $orderQuery
            ->expects($this->once())
            ->method('useOrderStatusQuery')
            ->willReturn($orderStatusQuery);

        $orderStatusQuery
            ->expects($this->once())
            ->method('filterByStatus')
            ->with(true)
            ->willReturn($orderStatusQuery);

        $orderStatusQuery
            ->expects($this->once())
            ->method('endUse')
            ->willReturn($orderQuery);

        $event = new ReceiveOrderQueryStatusEvent($orderQuery);
        $listener = new OrderRecoverListener();

        //act
        $listener->onReceiveOrderQueryStatusEvent($event);
    }

    public function test_onReceiveInvalidOrderEvent()
    {
        //arrange
        $con = \Propel::getConnection();
        $order = $this->getMockBuilder(Order::class)
            ->disableOriginalConstructor()
            ->setMethods(array('save', 'setOrderStatus'))
            ->getMock()
            ;
        $order
            ->expects($this->once())
            ->method('setOrderStatus')
            ->willReturnCallback(function(OrderStatus $orderStatus) use($order){
                $this->assertFalse($orderStatus->getStatus());
                return $order;
            });
        $order
            ->expects($this->once())
            ->method('save')
            ->with($con)
            ->willReturn(1);

        $event = new PaymentExpiredEvent($order, $con);
        $listener = new OrderRecoverListener();

        //act
        $listener->onReceiveInvalidOrderEvent($event);

        //assert
    }
}