<?php

namespace Widget\OrderBundle\Tests\Controller\BackendAPI;

use Backend\BaseBundle\Model\SiteUserQuery;
use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use JMS\Serializer\SerializationContext;
use Symfony\Component\HttpFoundation\Request;

class OrderDashboardControllerTest extends BaseWebTestCase
{
    public function test_dashBoardAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_order_backendapi_orderdashboard_dashboard'),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        // assert
        $this->assertTrue($response->isOk());
        $this->assertArrayHasKey('last', $responseArray);
        $this->assertArrayHasKey('hasNotPaid', $responseArray);
        $this->assertArrayHasKey('paidFail', $responseArray);
        $this->assertArrayHasKey('statusCount', $responseArray);
        $this->assertArrayHasKey('topOrder', $responseArray);
    }

    protected function createToken($user, $origin = 'http://localhost')
    {
        $request = Request::create('');
        $request->headers->set('Origin', $origin);
        $secretJwtToken = $this->client->getContainer()->get('secret_jwt_token');
        $serializer = $this->client->getContainer()->get('serializer');
        return $secretJwtToken->createJWTToken($request, $serializer->toArray(
            $user,
            SerializationContext::create()->setGroups(array('token'))
        ));
    }
}