<?php
namespace Widget\OrderBundle\Service;

use JMS\DiExtraBundle\Annotation as DI;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Widget\OrderBundle\Event\ProductAddEvent;
use Widget\OrderBundle\Model\Order;
use Widget\OrderBundle\Model\OrderItem;

/**
 * @DI\Service("widget.order_bundle.order_builder")
 */
class OrderBuilder
{

    /** @var  \PropelPDO */
    protected $con;

    /** @var  EventDispatcherInterface */
    protected $eventDispatcher;

    /** @var  Order */
    protected $order;

    protected $errors = array();

    /**
     * @DI\InjectParams()
     */
    public function injectEventDispatcher(EventDispatcherInterface $eventDispatcher)
    {
        $this->eventDispatcher = $eventDispatcher;
    }

    public function create($memberId, \PropelPDO $con = null)
    {
        $this->con = $con;
        $this->order = new Order();
        $this->order->setMemberId($memberId);
        return $this;
    }

    /**
     * @param $id
     * @param $count
     * @return ProductAddEvent
     */
    protected function queryProduct($id, $count)
    {
        $event = new ProductAddEvent($id, $count, $this->con);
        $this->eventDispatcher->dispatch(ProductAddEvent::EVENT_NAME, $event);
        return $event;
    }

    protected function addOrderItem(Order $order, ProductAddEvent $event)
    {
        $orderItem = new OrderItem();
        $orderItem
            ->setQuantity($event->getCount())
            ->setProductId($event->getId())
            ->setProductName($event->getProductName())
            ->setUnitPrice($event->getProductPrice())
        ;
        $order->addProducts($orderItem);

    }

    /**
     * @return array
     */
    public function getErrors()
    {
        return $this->errors;
    }

    protected function addError($id, $error)
    {
        $this->errors[$id] = $error;
    }

    /**
     * 1.dispatchEvent取得產品名稱、價格
     * 2.把取得產品名稱、價格，寫回訂單item裡面
     */
    public function add($id, $count)
    {
        $event = $this->queryProduct($id, $count);

        if($event->getError() === null) {
            $this->addOrderItem($this->order, $event);
            return $this;
        }

        $this->addError($event->getId(), $event->getError());
        return $this;
    }

    public function getOrder()
    {
        return $this->order;
    }

}