<?php
namespace Widget\OrderBundle\Service\Discount;


use Backend\BaseBundle\SiteConfig\SiteConfigBuilder;
use JMS\DiExtraBundle\Annotation as DI;
use Widget\OrderBundle\Event\DiscountChainEvent;
use Widget\OrderBundle\Model\Order;
use Widget\OrderBundle\Model\OrderItem;


class DiscountOff extends AbstractDiscount
{
    /** @var  SiteConfigBuilder */
    protected $configBuilder;

    /**
     * @DI\Observe(DiscountChainEvent::EVENT_NAME)
     */
    public function onQueryChain(DiscountChainEvent $event)
    {
        $event->addChain('off', 'form.choice.discount_config.off');
    }

    /**
     * @DI\InjectParams({
     *    "configBuilder" = @DI\Inject("backend_base.site_config_builder"),
     * })
     */
    public function injectConfigBuilder(SiteConfigBuilder $configBuilder)
    {
        $this->configBuilder = $configBuilder;
    }

    public function process(Order $order, \PropelPDO $con = null)
    {
        $siteConfig = $this->configBuilder->build();

        if(!($config = $siteConfig->get('widget_order.discount')) || !isset($config['DiscountOff']) || !isset($config['DiscountOff']['rate']) || !isset($config['DiscountOff']['full_amount'])){
            return;
        }

        $this->processed = true;

        $discountOff = $config['DiscountOff']['rate'];
        if ($order->getAmountForPay() >= $config['DiscountOff']['full_amount']) {
            $discount = -round($order->getAmount() - $order->getAmountForPay() * $discountOff);
            $orderItem = new OrderItem();
            $orderItem
                ->setQuantity(1)
                ->setUnitPrice($discount)
                ->setProductName("$discountOff discount")
                ->setOrder($order);
            //同步金額
            $order->syncAmount($con);
        }
    }
}