module.exports =
{
  "list": {
    "id": {
      "label": "#",
      "type": "id",
      "sort": true,
      "search": true
      searchConfig:
        key: "id"
        type: "text"
        like: true
    },
    "member.email": {
      "label": "index.refund.email",
      "type": "link",
      "sort": true,
      "search": true
      config:
        target: '_blank'
        reference: [
          { filterBy: 'email', key: 'member.email', type: 'search' }
        ]
        route:
          name: 'member-list'
          query:
            sort: 'created_at=desc'

    },
    "member.member_info.name": {
      "label": "index.refund.member_info.name",
      "type": "text",
      "sort": true,
      "search": true
    },
    "accept": {
      "label": "index.refund.accept",
      "type": "text",
      "sort": true,
      "search": true
      "config": {
        label_prefix: "index.refund.accept_status"
      }
      searchConfig:
        key: "accept"
        type: "select"
        options: [
          { label: 'index.refund.accept_status.y', value: 'y' }
          { label: 'index.refund.accept_status.n', value: 'n' }
        ]
        choiceValue: "value"
        choiceLabel: "label"
    },

    "created_at": {
      "label": "index.refund.created_at",
      "type": "datetime-local",
      "sort": true
      defaultSorting: 'desc'
    }
  },
  "extra": [],
  "action": [
    {
      "name": "edit",
      "label": "action.edit",
      "roles": ["ROLE_ORDER_WRITE"]
      "route": 'refund-edit'
    }
    {
      "roles": ["ROLE_MEMBER_READ", "ROLE_ORDER_READ", "ROLE_ORDER_WRITE"]
      "component": require 'components/widgetorder/customize/list/refund-member.vue'
    }
  ]
}