module.exports =
{
  "list": {
    "id": {
      "label": "index.order_status.id",
      "type": "id",
      "sort": true,
      "search": true
      searchConfig:
        key: "id"
        type: "text"
        like: true
    },
    "name": {
      "label": "index.order_status.name",
      "type": "text",
      "sort": true,
      "quick": true,
      "search": true
      searchConfig:
        key: "name"
        type: "text"
        like: true
    },
    "created_at": {
      "label": "index.order_status.created_at",
      "type": "datetime-local",
      "sort": true
      defaultSorting: 'desc'
    }
  },
  "extra": [
    {
      "name": "new",
      "label": "form.button.new",
      "roles": ["ROLE_ORDER_WRITE"]
      "route": 'orderstatus-new'
    },
  ],
  "action": [
    {
      "name": "edit",
      "label": "action.edit",
      "roles": ["ROLE_ORDER_WRITE"]
      "route": 'orderstatus-edit'
    }
  ]
}