module.exports =
{
  "list": {
    "id": {
      "label": "#",
      "type": "id",
      "sort": true,
      "search": true
      searchConfig:
        key: "id"
        type: "text"
        like: true
    },
    "order_info.buyer_name": {
      "label": "index.order.info.buyer_name",
      "type": "text",
      "sort": true,
      "search": true
      searchConfig:
        key: "order_info.buyer_name"
        type: "text"
        like: true
    },
    "order_info.buyer_phone": {
      "label": "index.order.info.buyer_phone",
      "type": "text",
      "sort": true,
      "search": true
      searchConfig:
        key: "order_info.buyer_phone"
        type: "text"
        like: true
    },
    "order_info.buyer_email": {
      "label": "index.order.info.buyer_email",
      "type": "text",
      "sort": true,
      "search": true
      searchConfig:
        key: "order_info.buyer_email"
        type: "text"
        like: true
    },
    "payment.payment_type": {
      "label": "index.order.payment_type",
      "type": "text",
      "sort": true,
      "search": true
      "config": {
        label_prefix: "index_value.payment.payment_type"
      }
      searchConfig:
        key: "payment.payment_type"
        type: "select"
        api: "order.payment"
        choiceValue: "id"
        choiceLabel: "payment_type"
    },
    "amount": {
      "label": "index.order.amount",
      "type": "text",
    },
    "amount_for_pay": {
      "label": "index.order.amount_for_pay",
      "type": "text",
    },
    "order_status.name": {
      "label": "index.order.status",
      "type": "text",
      "sort": true,
      "search": true
      searchConfig:
        key: "order_status_id"
        type: "select"
        api: "order.orderStatus"
        choiceValue: "id"
        choiceLabel: "name"
    },
    "payment.payment_status": {
      "label": "index.order.payment_status",
      "type": "text",
      search: true
      "sort": true,
      searchConfig:
        key: "payment.payment_status"
        type: "select"
        api: "order.paymentStatus"
        choiceValue: "id"
        choiceLabel: "name"
      "config": {
        label_prefix: "index_value.payment.payment_status"
      }
    },
    "created_at": {
      "label": "index.order.created_at",
      "type": "datetime-local",
      "sort": true
      defaultSorting: 'desc'
    }
  },
  "extra": [
    {
      name: "quick_search"
      label: "action.quickSearch"
      roles: ["ROLE_ORDER_WRITE"]
      component: require 'components/backendbase/partial/list/extra/quicksearch.vue'
      config:
        key: 'order_status_id'
        getStatus: 'order.orderStatus'
        apiName: 'order'
        status: [
          { label: 'index.order.quick_search.all', value: 'all' }
        ]
    }
  ],
  "action": [
    {
      "name": "view",
      "label": "action.view",
      "roles": ["ROLE_ORDER_READ", "ROLE_ORDER_WRITE"]
      "route": 'order-view'
    },
    {
      "name": "edit",
      "label": "action.edit",
      "roles": ["ROLE_ORDER_WRITE"]
      "route": 'order-edit'
    }
    {
      "roles": ["ROLE_MEMBER_READ", "ROLE_ORDER_READ", "ROLE_ORDER_WRITE"]
      "component": require 'components/widgetorder/customize/list/member.vue'
    }
    {
      "name": "exportlist",
      "label": "action.exportlist",
      "roles": ["ROLE_ORDER_READ", "ROLE_ORDER_WRITE"]
      "route": 'exportlist-view'
      "target": "_blank"
    }
    {
      "name": "shiplist",
      "label": "action.shiplist",
      "roles": ["ROLE_ORDER_READ", "ROLE_ORDER_WRITE"]
      "route": 'shiplist-view'
      "target": "_blank"
    }
  ]
}