module.exports = (api) ->
  api.order =
    search: (data) ->
      api.request "GET", "/orders", data
    create: (data) ->
      api.request "POST", "/orders", data
    read: (id) ->
      api.request "GET", "/order/#{id}"
    update: (id, data) ->
      api.request  "PUT", "/order/#{id}", data
    orderStatus: () ->
      api.request "GET", "/orderstatuss/all"
    paymentStatus: () ->
      new Promise (resolve, reject) ->
        data = [
          { id: 'i', name: "index_value.payment.payment_status.i" }
          { id: 'p', name: "index_value.payment.payment_status.p" }
          { id: 'f', name: "index_value.payment.payment_status.f" }
        ]
        resolve data
    getPayment: () ->
      new Promise (resolve, reject) ->
        data = [
          {
            id: false
            name: "index_value.payment.payment_paid.false"
          }
          {
            id: true
            name: "index_value.payment.payment_paid.true"
          }
        ]
        resolve data
    payment: () ->
      api.request "GET", "/payments/payment"
    orderInfoUpdate: (id, data) ->
      api.request "PUT", "/orderinfo/#{id}", data
    getOrderLog: (id) ->
      api.request "GET", "/orderlogs/#{id}/all"
    orderLogCreate: (data) ->
      api.request "POST", "/orderlogs", data
    export: (data, url) ->
      api.filestream "POST", url, data, true
    sendMail: (id) ->
      api.request "GET", "/order/send/#{id}"