<?php
/**
 * Created by PhpStorm.
 * User: bubble
 * Date: 2016/7/12
 * Time: 下午 6:32
 */

namespace Widget\OrderBundle\Event;


use Symfony\Component\EventDispatcher\Event;
use Widget\OrderBundle\Model\OrderQuery;

class ReceiveOrderQueryStatusEvent extends Event
{
    /**
     * 當發dispatcher時，這邊接收到會帶query條件
     * 而要帶著processed則是當訂單已經處理過時，會變更為ture狀態，則可繼續詢問接下來的listener事件，false=可能沒裝付款模組，就不用繼續處理
     */
    const EVENT_NAME = 'event.receive.order.query.status';

    /** @var  boolean */
    protected $processed = false;

    /** @var OrderQuery  */
    protected $query;

    public function __construct(OrderQuery $query)
    {
        $this->query = $query;
    }

    /**
     * @return OrderQuery
     */
    public function getQuery()
    {
        return $this->query;
    }

    /**
     * @return boolean
     */
    public function isProcessed()
    {
        return $this->processed;
    }

    /**
     * @param boolean $processed
     */
    public function setProcessed($processed = true)
    {
        $this->processed = $processed;
    }

}